/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.config.spring.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.spring.internal.dsl.model.ComponentModelReader;
import org.mule.runtime.config.spring.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.spring.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.config.spring.internal.dsl.model.extension.xml.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.spring.internal.dsl.model.extension.xml.OperationComponentModelModelProperty;
import org.mule.runtime.config.spring.internal.dsl.model.extension.xml.XmlExtensionModelProperty;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.catalog.loader.common.XmlMatcher;
import org.mule.runtime.extension.internal.loader.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.runtime.extension.internal.loader.catalog.model.TypesCatalog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class XmlExtensionLoaderDelegate {
    private static final String PARAMETER_NAME = "name";
    private static final String PARAMETER_DEFAULT_VALUE = "defaultValue";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MODULE_NAME = "name";
    private static final String MODULE_PREFIX_ATTRIBUTE = "prefix";
    private static final String MODULE_NAMESPACE_ATTRIBUTE = "namespace";
    private static final String MODULE_NAMESPACE_NAME = "module";
    protected static final String CONFIG_NAME = "config";
    private static final Map<String, ParameterRole> parameterRoleTypes = ImmutableMap.builder().put((Object)"BEHAVIOUR", (Object)ParameterRole.BEHAVIOUR).put((Object)"CONTENT", (Object)ParameterRole.CONTENT).put((Object)"PRIMARY", (Object)ParameterRole.PRIMARY_CONTENT).build();
    private static final String CATEGORY = "category";
    private static final String VENDOR = "vendor";
    private static final String MIN_MULE_VERSION = "minMuleVersion";
    private static final String DOC_DESCRIPTION = "doc:description";
    private static final String PASSWORD = "password";
    private static final String ORDER_ATTRIBUTE = "order";
    private static final String TAB_ATTRIBUTE = "tab";
    private static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    private static final String SUMMARY_ATTRIBUTE = "summary";
    private static final String EXAMPLE_ATTRIBUTE = "example";
    private static final String ROLE = "role";
    private static final String ATTRIBUTE_USE = "use";
    private static final Pattern VALID_XML_NAME = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("operation").build();
    private static final ComponentIdentifier OPERATION_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("property").build();
    private static final ComponentIdentifier OPERATION_PARAMETERS_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameters").build();
    private static final ComponentIdentifier OPERATION_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("parameter").build();
    private static final ComponentIdentifier OPERATION_BODY_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("body").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output").build();
    private static final ComponentIdentifier OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("output-attributes").build();
    private static final ComponentIdentifier MODULE_IDENTIFIER = ComponentIdentifier.builder().namespace("module").name("module").build();
    public static final String XSD_SUFFIX = ".xsd";
    private static final String XML_SUFFIX = ".xml";
    private static final String TYPES_XML_SUFFIX = "-catalog.xml";
    private final String modulePath;
    private Optional<TypesCatalog> typesCatalog;
    private TypeResolver typeResolver;

    private static ParameterRole getRole(String role) {
        if (!parameterRoleTypes.containsKey(role)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parametrized role [%s] doesn't match any of the expected types [%s]", role, String.join((CharSequence)", ", parameterRoleTypes.keySet())));
        }
        return parameterRoleTypes.get(role);
    }

    public XmlExtensionLoaderDelegate(String modulePath) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)modulePath) ? 1 : 0) != 0, (Object)"modulePath must not be empty");
        this.modulePath = modulePath;
    }

    public void declare(ExtensionLoadingContext context) {
        URL resource = this.getResource(this.modulePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("There's no reachable XML in the path '%s'", this.modulePath));
        }
        try {
            this.loadCustomTypes();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("The custom type file [%s] for the module '%s' cannot be read properly", this.getCustomTypeFilename(), this.modulePath), e);
        }
        Document moduleDocument = this.getModuleDocument(context, resource);
        XmlApplicationParser xmlApplicationParser = new XmlApplicationParser(new SpiServiceRegistry(), Collections.singletonList(Thread.currentThread().getContextClassLoader()));
        Optional<ConfigLine> parseModule = xmlApplicationParser.parse(moduleDocument.getDocumentElement());
        if (!parseModule.isPresent()) {
            throw new IllegalArgumentException(String.format("There was an issue trying to read the stream of '%s'", resource.getFile()));
        }
        ComponentModelReader componentModelReader = new ComponentModelReader(new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider()));
        String configFileName = this.modulePath.substring(this.modulePath.lastIndexOf("/") + 1);
        ComponentModel componentModel = componentModelReader.extractComponentDefinitionModel(parseModule.get(), configFileName);
        this.loadModuleExtension(context.getExtensionDeclarer(), componentModel);
    }

    private URL getResource(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource);
    }

    private void loadCustomTypes() throws Exception {
        this.typesCatalog = Optional.empty();
        String customTypes = this.getCustomTypeFilename();
        URL resourceCustomType = this.getResource(customTypes);
        if (resourceCustomType != null) {
            Element typesDocument = TypesCatalogXmlLoader.parseRootElement(resourceCustomType);
            Optional<XmlMatcher> match = XmlMatcher.match(typesDocument, TypesCatalogXmlLoader.ELEM_MULE);
            if (match.isPresent()) {
                TypesCatalogXmlLoader typesCatalogXmlLoader = new TypesCatalogXmlLoader();
                this.typesCatalog = Optional.of(typesCatalogXmlLoader.load(resourceCustomType));
                this.typeResolver = this.getEmptyTypeResolver();
            } else {
                this.typeResolver = TypeResolver.createFrom(resourceCustomType, Thread.currentThread().getContextClassLoader());
            }
        } else {
            this.typeResolver = this.getEmptyTypeResolver();
        }
    }

    private TypeResolver getEmptyTypeResolver() {
        return TypeResolver.create(Thread.currentThread().getContextClassLoader());
    }

    private String getCustomTypeFilename() {
        return this.modulePath.replace(XML_SUFFIX, TYPES_XML_SUFFIX);
    }

    private Document getModuleDocument(ExtensionLoadingContext context, URL resource) {
        XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader = XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader();
        try {
            HashSet<ExtensionModel> extensions = new HashSet<ExtensionModel>(context.getDslResolvingContext().getExtensions());
            return xmlConfigurationDocumentLoader.loadDocument(extensions, resource.getFile(), resource.openStream());
        }
        catch (IOException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("There was an issue reading the stream for the resource %s", resource.getFile())));
        }
    }

    private void loadModuleExtension(ExtensionDeclarer declarer, ComponentModel moduleModel) {
        if (!moduleModel.getIdentifier().equals(MODULE_IDENTIFIER)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("The root element of a module must be '%s', but found '%s'", MODULE_IDENTIFIER.toString(), moduleModel.getIdentifier().toString())));
        }
        String name = moduleModel.getParameters().get("name");
        String version = "4.0";
        String category = moduleModel.getParameters().get(CATEGORY);
        String vendor = moduleModel.getParameters().get(VENDOR);
        String minMuleVersion = moduleModel.getParameters().get(MIN_MULE_VERSION);
        declarer.named(name).describedAs(this.getDescription(moduleModel)).fromVendor(vendor).withMinMuleVersion(new MuleVersion(minMuleVersion)).onVersion(version).withCategory(Category.valueOf(category.toUpperCase())).withXmlDsl(this.getXmlDslModel(moduleModel, name, version));
        declarer.withModelProperty(new XmlExtensionModelProperty());
        Optional<ConfigurationDeclarer> configurationDeclarer = this.loadPropertiesFrom(declarer, moduleModel);
        if (configurationDeclarer.isPresent()) {
            this.loadOperationsFrom(configurationDeclarer.get(), moduleModel);
        } else {
            this.loadOperationsFrom(declarer, moduleModel);
        }
    }

    private XmlDslModel getXmlDslModel(ComponentModel moduleModel, String name, String version) {
        Optional<String> prefix = Optional.ofNullable(moduleModel.getParameters().get(MODULE_PREFIX_ATTRIBUTE));
        Optional<String> namespace = Optional.ofNullable(moduleModel.getParameters().get(MODULE_NAMESPACE_ATTRIBUTE));
        return XmlModelUtils.createXmlLanguageModel(prefix, namespace, name, version);
    }

    private String getDescription(ComponentModel componentModel) {
        return componentModel.getParameters().getOrDefault(DOC_DESCRIPTION, "");
    }

    private List<ComponentModel> extractGlobalElementsFrom(ComponentModel moduleModel) {
        return moduleModel.getInnerComponents().stream().filter(child -> !child.getIdentifier().equals(OPERATION_PROPERTY_IDENTIFIER) && !child.getIdentifier().equals(OPERATION_IDENTIFIER)).collect(Collectors.toList());
    }

    private Optional<ConfigurationDeclarer> loadPropertiesFrom(ExtensionDeclarer declarer, ComponentModel moduleModel) {
        List<ComponentModel> globalElementsComponentModel = this.extractGlobalElementsFrom(moduleModel);
        List properties = moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PROPERTY_IDENTIFIER)).collect(Collectors.toList());
        if (!properties.isEmpty() || !globalElementsComponentModel.isEmpty()) {
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(CONFIG_NAME);
            configurationDeclarer.withModelProperty(new GlobalElementComponentModelModelProperty(globalElementsComponentModel));
            properties.stream().forEach(param -> this.extractProperty(configurationDeclarer, (ComponentModel)param));
            return Optional.of(configurationDeclarer);
        }
        return Optional.empty();
    }

    private void loadOperationsFrom(HasOperationDeclarer declarer, ComponentModel moduleModel) {
        moduleModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_IDENTIFIER)).forEach(operationModel -> this.extractOperationExtension(declarer, (ComponentModel)operationModel));
    }

    private void extractOperationExtension(HasOperationDeclarer declarer, ComponentModel operationModel) {
        String operationName = this.assertValidName(operationModel.getNameAttribute());
        OperationDeclarer operationDeclarer = declarer.withOperation(operationName);
        ComponentModel bodyComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_BODY_IDENTIFIER)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The operation '%s' is missing the <body> statement", operationName)));
        operationDeclarer.withModelProperty(new OperationComponentModelModelProperty(operationModel, bodyComponentModel));
        operationDeclarer.describedAs(this.getDescription(operationModel));
        this.extractOperationParameters(operationDeclarer, operationModel);
        this.extractOutputType(operationDeclarer.withOutput(), OPERATION_OUTPUT_IDENTIFIER, operationModel);
        this.extractOutputType(operationDeclarer.withOutputAttributes(), OPERATION_OUTPUT_ATTRIBUTES_IDENTIFIER, operationModel);
    }

    private String assertValidName(String name) {
        if (!VALID_XML_NAME.matcher(name).matches()) {
            throw new IllegalModelDefinitionException(String.format("The name being used '%s' is not XML valid, it must start with a letter and can be followed by any letter, number or -, _. ", name));
        }
        return name;
    }

    private void extractOperationParameters(OperationDeclarer operationDeclarer, ComponentModel componentModel) {
        Optional<ComponentModel> optionalParametersComponentModel = componentModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETERS_IDENTIFIER)).findAny();
        if (optionalParametersComponentModel.isPresent()) {
            optionalParametersComponentModel.get().getInnerComponents().stream().filter(child -> child.getIdentifier().equals(OPERATION_PARAMETER_IDENTIFIER)).forEach(param -> {
                String role = param.getParameters().get(ROLE);
                this.extractParameter(operationDeclarer, (ComponentModel)param, XmlExtensionLoaderDelegate.getRole(role));
            });
        }
    }

    private void extractProperty(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param) {
        this.extractParameter(parameterizedDeclarer, param, ParameterRole.BEHAVIOUR);
    }

    private void extractParameter(ParameterizedDeclarer parameterizedDeclarer, ComponentModel param, ParameterRole role) {
        Map<String, String> parameters = param.getParameters();
        String receivedInputType = parameters.get(TYPE_ATTRIBUTE);
        LayoutModel.LayoutModelBuilder layoutModelBuilder = LayoutModel.builder();
        if (Boolean.parseBoolean(parameters.get(PASSWORD))) {
            layoutModelBuilder.asPassword();
        }
        layoutModelBuilder.order(this.getOrder(parameters.get(ORDER_ATTRIBUTE)));
        layoutModelBuilder.tabName(this.getTab(parameters.get(TAB_ATTRIBUTE)));
        DisplayModel.DisplayModelBuilder displayModelBuilder = DisplayModel.builder();
        displayModelBuilder.displayName(parameters.get(DISPLAY_NAME_ATTRIBUTE));
        displayModelBuilder.summary(parameters.get(SUMMARY_ATTRIBUTE));
        displayModelBuilder.example(parameters.get(EXAMPLE_ATTRIBUTE));
        MetadataType parameterType = this.extractType(receivedInputType);
        ParameterDeclarer parameterDeclarer = this.getParameterDeclarer(parameterizedDeclarer, parameters);
        ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)parameterDeclarer.describedAs(this.getDescription(param))).withLayout(layoutModelBuilder.build())).withDisplayModel(displayModelBuilder.build())).withRole(role)).ofType(parameterType);
    }

    private String getTab(String tab) {
        return StringUtils.isBlank((CharSequence)tab) ? "General" : tab;
    }

    private int getOrder(String order) {
        try {
            return Integer.parseInt(order);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private ParameterDeclarer getParameterDeclarer(ParameterizedDeclarer parameterizedDeclarer, Map<String, String> parameters) {
        String parameterName = this.assertValidName(parameters.get("name"));
        String parameterDefaultValue = parameters.get(PARAMETER_DEFAULT_VALUE);
        UseEnum use = UseEnum.valueOf(parameters.get(ATTRIBUTE_USE));
        if (UseEnum.REQUIRED.equals((Object)use) && StringUtils.isNotBlank((CharSequence)parameterDefaultValue)) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] cannot have the %s attribute set to %s when it has a default value", new Object[]{parameterName, ATTRIBUTE_USE, UseEnum.REQUIRED}));
        }
        boolean parameterRequired = UseEnum.REQUIRED.equals((Object)use) || UseEnum.AUTO.equals((Object)use) && StringUtils.isBlank((CharSequence)parameterDefaultValue);
        return parameterRequired ? parameterizedDeclarer.onDefaultParameterGroup().withRequiredParameter(parameterName) : parameterizedDeclarer.onDefaultParameterGroup().withOptionalParameter(parameterName).defaultingTo(parameterDefaultValue);
    }

    private void extractOutputType(OutputDeclarer outputDeclarer, ComponentIdentifier componentIdentifier, ComponentModel operationModel) {
        Optional<ComponentModel> outputAttributesComponentModel = operationModel.getInnerComponents().stream().filter(child -> child.getIdentifier().equals(componentIdentifier)).findFirst();
        if (outputAttributesComponentModel.isPresent()) {
            String receivedOutputAttributeType = outputAttributesComponentModel.get().getParameters().get(TYPE_ATTRIBUTE);
            MetadataType metadataType = this.extractType(receivedOutputAttributeType);
            ((OutputDeclarer)outputDeclarer.describedAs(this.getDescription(outputAttributesComponentModel.get()))).ofType(metadataType);
        } else {
            outputDeclarer.ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).voidType().build());
        }
    }

    private MetadataType extractType(String receivedType) {
        Optional<Object> metadataType;
        block4: {
            metadataType = Optional.empty();
            try {
                metadataType = this.typeResolver.resolveType(receivedType);
            }
            catch (TypeResolverException e) {
                if (this.typesCatalog.isPresent()) {
                    metadataType = this.typesCatalog.get().resolveType(receivedType);
                }
                if (metadataType.isPresent()) break block4;
                throw new IllegalParameterModelDefinitionException(String.format("The type obtained [%s] cannot be resolved", receivedType), e);
            }
        }
        if (!metadataType.isPresent()) {
            String errorMessage = String.format("should not have reach here. Type obtained [%s] when supported default types are [%s].", receivedType, String.join((CharSequence)", ", PrimitiveTypesTypeLoader.PRIMITIVE_TYPES.keySet()));
            throw new IllegalParameterModelDefinitionException(errorMessage);
        }
        return (MetadataType)metadataType.get();
    }

    private static enum UseEnum {
        REQUIRED,
        OPTIONAL,
        AUTO;

    }
}

