/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public class ContentParameterModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            public void onConfiguration(ConfigurationModel model) {
                ContentParameterModelValidator.this.validateNoContent(model, problemsReporter);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                ContentParameterModelValidator.this.validateNoContent(model, problemsReporter);
            }

            @Override
            protected void onOperation(OperationModel model) {
                ContentParameterModelValidator.this.validateContent(model, problemsReporter);
            }

            @Override
            protected void onSource(SourceModel model) {
                ContentParameterModelValidator.this.validateContent(model, problemsReporter);
            }

            @Override
            protected void onParameter(final ParameterGroupModel groupModel, final ParameterModel model) {
                model.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitObject(ObjectType objectType) {
                        this.validateNoContentField(objectType);
                        this.validateNoMetadataField(objectType);
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        arrayType.getType().accept(this);
                    }

                    @Override
                    public void visitUnion(UnionType unionType) {
                        unionType.getTypes().forEach(t -> t.accept(this));
                    }

                    void validateNoContentField(ObjectType objectType) {
                        List contentFields = objectType.getFields().stream().filter(TypeUtils::isContent).map(MetadataTypeUtils::getLocalPart).collect(Collectors.toList());
                        if (!contentFields.isEmpty()) {
                            problemsReporter.addError(new Problem(model, String.format("Parameter '%s' of type '%s' in group '%s' contains content fields: [%s]. Content fields are not allowed in complex types.", model.getName(), ExtensionMetadataTypeUtils.getId(objectType), groupModel.getName(), Joiner.on((String)", ").join(contentFields))));
                        }
                    }

                    void validateNoMetadataField(ObjectType objectType) {
                        ExtensionMetadataTypeUtils.getType(objectType).ifPresent(clazz -> {
                            List metadataFields = TypeUtils.getAllFields(clazz).stream().filter(f -> f.getAnnotation(MetadataKeyId.class) != null || f.getAnnotation(TypeResolver.class) != null).map(Field::getName).collect(Collectors.toList());
                            if (!metadataFields.isEmpty()) {
                                problemsReporter.addError(new Problem(model, String.format("Parameter '%s' of type '%s' in group '%s' contains fields [%s] annotated with metadata and dynamic type resolution. Metadata annotations cannot be used as part of types, and are allowed only in Parameters", model.getName(), ExtensionMetadataTypeUtils.getId(objectType), groupModel.getName(), Joiner.on((String)", ").join(metadataFields))));
                            }
                        });
                    }
                });
            }
        }.walk(extensionModel);
    }

    private void validateNoContent(ParameterizedModel model, ProblemsReporter problemsReporter) {
        List<ParameterModel> contentParameters = this.getContentParameters(model);
        if (!contentParameters.isEmpty()) {
            problemsReporter.addError(this.problem(model, String.format("contains content parameters. Content parameters are not allowed on %s components", NameUtils.getComponentModelTypeName(model))));
        }
    }

    private void validateContent(ParameterizedModel model, ProblemsReporter problemsReporter) {
        List<ParameterModel> contentParameters = this.getContentParameters(model);
        if (contentParameters.isEmpty()) {
            return;
        }
        this.validatePrimaryContent(model, contentParameters, problemsReporter);
        this.validateDsl(model, contentParameters, problemsReporter);
        this.validateExpressionSupport(model, contentParameters, problemsReporter);
    }

    private void validateExpressionSupport(ParameterizedModel model, List<ParameterModel> contentParameters, ProblemsReporter problemsReporter) {
        List<ParameterModel> expressionLess = contentParameters.stream().filter(p -> p.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED).collect(Collectors.toList());
        if (!expressionLess.isEmpty()) {
            problemsReporter.addError(this.problem(model, String.format("contains content parameters which don't allow expressions. Expressions are mandatory for all content parameters. Offending parameters are: [%s]", this.join(expressionLess))));
        }
    }

    private void validateDsl(ParameterizedModel model, List<ParameterModel> contentParameters, ProblemsReporter problemsReporter) {
        List<ParameterModel> offending = contentParameters.stream().filter(p -> p.getDslConfiguration().allowsReferences()).collect(Collectors.toList());
        if (!offending.isEmpty()) {
            problemsReporter.addError(this.problem(model, String.format("contains content parameters which allow references. Offending parameters are: [%s]", this.join(offending))));
        }
    }

    private Problem problem(ParameterizedModel model, String message) {
        return new Problem(model, String.format("'%s' %s %s ", NameUtils.getComponentModelTypeName(model), model.getName(), message));
    }

    private void validatePrimaryContent(ParameterizedModel model, List<ParameterModel> contentParameters, ProblemsReporter problemsReporter) {
        List<ParameterModel> primaryContents = contentParameters.stream().filter(p -> p.getRole() == ParameterRole.PRIMARY_CONTENT).collect(Collectors.toList());
        if (primaryContents.isEmpty()) {
            problemsReporter.addError(this.problem(model, String.format("contains %d content parameters but none of them is primary", contentParameters.size())));
        } else if (primaryContents.size() > 1) {
            problemsReporter.addError(this.problem(model, String.format("contains %d content parameters marked as primary. Only one primary content parameter is allowed. Offending parameters are [%s]", primaryContents.size(), this.join(primaryContents))));
        }
    }

    private List<ParameterModel> getContentParameters(ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(ExtensionModelUtils::isContent).collect(Collectors.toList());
    }

    private String join(List<ParameterModel> offending) {
        return Joiner.on((String)", ").join(offending);
    }
}

