/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.soap.metadata;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;

public class SoapOutputTypeBuilder {
    public static final String BODY_FIELD = "body";
    public static final String HEADERS_FIELD = "headers";
    public static final String ATTACHMENTS_FIELD = "attachments";

    public static MetadataType buildOutputType(MetadataType body2, MetadataType headers, MetadataType attachments, BaseTypeBuilder builder) {
        if (SoapOutputTypeBuilder.isNullType(body2) && SoapOutputTypeBuilder.isNullType(attachments) && SoapOutputTypeBuilder.isNullType(headers)) {
            return builder.nullType().build();
        }
        ObjectTypeBuilder object = builder.objectType();
        if (!SoapOutputTypeBuilder.isNullType(body2)) {
            object.addField().key(BODY_FIELD).value(body2);
        }
        if (!SoapOutputTypeBuilder.isNullType(headers)) {
            object.addField().key(HEADERS_FIELD).value(headers);
        }
        if (!SoapOutputTypeBuilder.isNullType(attachments)) {
            object.addField().key(ATTACHMENTS_FIELD).value().arrayType().of(builder.binaryType());
        }
        return object.build();
    }

    private static boolean isNullType(MetadataType type) {
        return type instanceof NullType;
    }
}

