/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.descriptor;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;

public class ArtifactDescriptor {
    public static final String MULE_ARTIFACT_JSON_DESCRIPTOR = "mule-artifact.json";
    public static final String MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "mule-artifact.json").toString();
    private final String name;
    private File rootFolder;
    private ClassLoaderModel classLoaderModel = ClassLoaderModel.NULL_CLASSLOADER_MODEL;
    private BundleDescriptor bundleDescriptor;
    private MuleVersion minMuleVersion;

    public ArtifactDescriptor(String name) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)name), "Artifact name cannot be empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(File rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException("Root folder cannot be null");
        }
        this.rootFolder = rootFolder;
    }

    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public void setMinMuleVersion(MuleVersion minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public ClassLoaderModel getClassLoaderModel() {
        return this.classLoaderModel;
    }

    public void setClassLoaderModel(ClassLoaderModel classLoaderModel) {
        this.classLoaderModel = classLoaderModel;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public void setBundleDescriptor(BundleDescriptor bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.getName());
    }
}

