/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelParameterObjectFactory
extends AbstractExtensionObjectFactory<Object>
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopLevelParameterObjectFactory.class);
    private DefaultObjectBuilder builder;
    private Class<Object> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private String name;
    private Object staticProduct = null;

    public TopLevelParameterObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        ClassUtils.withContextClassLoader(classLoader, () -> {
            this.objectClass = JavaTypeUtils.getType(type);
            this.builder = new DefaultObjectBuilder<Object>(this.objectClass);
        });
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.staticProduct != null) {
            LifecycleUtils.initialiseIfNeeded(this.staticProduct, true, this.muleContext);
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.staticProduct != null) {
            LifecycleUtils.startIfNeeded(this.staticProduct);
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.staticProduct != null) {
            LifecycleUtils.stopIfNeeded(this.staticProduct);
        }
    }

    @Override
    public void dispose() {
        if (this.staticProduct != null) {
            LifecycleUtils.disposeIfNeeded(this.staticProduct, LOGGER);
        }
    }

    @Override
    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader(this.classLoader, () -> {
            ObjectBuilderValueResolver resolver;
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            if (this.name != null) {
                this.builder.setName(this.name);
            }
            if ((resolver = new ObjectBuilderValueResolver(this.builder, this.muleContext)).isDynamic()) {
                return resolver;
            }
            this.staticProduct = resolver.resolve(ValueResolvingContext.from(MuleExtensionUtils.getInitialiserEvent(this.muleContext)));
            return this.staticProduct;
        }, Exception.class, exception -> {
            throw exception;
        });
    }

    public void setName(String name) {
        this.name = name;
    }
}

