/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.time.Time;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.config.ExtensionConfig;
import org.mule.runtime.module.extension.internal.manager.ConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.DefaultConfigurationExpirationMonitor;
import org.mule.runtime.module.extension.internal.manager.ExtensionActivator;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.mule.runtime.module.extension.internal.manager.ExtensionRegistry;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExtensionManager
implements ExtensionManager,
MuleContextAware,
Initialisable,
Startable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionManager.class);
    private final ImplicitConfigurationProviderFactory implicitConfigurationProviderFactory = new DefaultImplicitConfigurationProviderFactory();
    private MuleContext muleContext;
    private ExtensionRegistry extensionRegistry;
    private ConfigurationExpirationMonitor configurationExpirationMonitor;
    private ExtensionErrorsRegistrant extensionErrorsRegistrant;
    private ExtensionActivator extensionActivator;

    @Override
    public void initialise() throws InitialisationException {
        this.extensionRegistry = new ExtensionRegistry(this.muleContext.getRegistry());
        this.extensionErrorsRegistrant = new ExtensionErrorsRegistrant(this.muleContext.getErrorTypeRepository(), this.muleContext.getErrorTypeLocator());
        this.extensionActivator = new ExtensionActivator(this.extensionErrorsRegistrant, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        this.configurationExpirationMonitor = this.newConfigurationExpirationMonitor();
        this.configurationExpirationMonitor.beginMonitoring();
        this.extensionActivator.start();
    }

    @Override
    public void stop() throws MuleException {
        this.extensionActivator.stop();
        this.configurationExpirationMonitor.stopMonitoring();
    }

    @Override
    public void registerExtension(ExtensionModel extensionModel) {
        String extensionName = extensionModel.getName();
        String extensionVersion = extensionModel.getVersion();
        String extensionVendor = extensionModel.getVendor();
        LOGGER.info("Registering extension {} (version: {} vendor: {} )", new Object[]{extensionName, extensionVersion, extensionVendor});
        if (this.extensionRegistry.containsExtension(extensionName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("An extension of name '{}' (version: {} vendor {}) is already registered. Skipping...", new Object[]{extensionName, extensionVersion, extensionVendor});
            }
        } else {
            ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(extensionModel), () -> {
                this.extensionRegistry.registerExtension(extensionName, extensionModel);
                this.extensionActivator.activateExtension(extensionModel);
            });
        }
    }

    @Override
    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.extensionRegistry.registerConfigurationProvider(configurationProvider);
    }

    @Override
    public ConfigurationInstance getConfiguration(String configurationProviderName, InternalEvent muleEvent) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get(muleEvent)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration(ExtensionModel extensionModel, ComponentModel componentModel, InternalEvent muleEvent) {
        ConfigurationInstance instance = this.getConfigurationProvider(extensionModel, componentModel).map(p -> p.get(muleEvent)).orElse(null);
        if (instance != null) {
            return Optional.of(instance);
        }
        Optional<ConfigurationModel> configurationModel = this.getConfigurationModelForExtension(extensionModel, ExtensionModelUtils.getConfigurationForComponent(extensionModel, componentModel));
        if (configurationModel.isPresent()) {
            this.createImplicitConfiguration(extensionModel, configurationModel.get(), muleEvent);
            return Optional.of(this.getConfiguration(MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, configurationModel.get()), muleEvent));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel) {
        Optional<ConfigurationModel> config = this.getConfigurationModelForExtension(extensionModel, ExtensionModelUtils.getConfigurationForComponent(extensionModel, componentModel));
        if (!config.isPresent() && ExtensionModelUtils.requiresConfig(extensionModel, componentModel)) {
            throw new IllegalStateException(String.format("No config-ref was specified for component '%s' of extension '%s'. Please specify which to use", componentModel.getName(), extensionModel.getName()));
        }
        return config.map(c -> this.getConfigurationProvider(MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, c))).orElse(Optional.empty());
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Preconditions.checkArgument(!StringUtils.isBlank(configurationProviderName), "cannot get configuration from a blank provider name");
        return this.extensionRegistry.getConfigurationProvider(configurationProviderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImplicitConfiguration(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel, InternalEvent muleEvent) {
        String implicitConfigurationProviderName = MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, implicitConfigurationModel);
        if (!this.extensionRegistry.getConfigurationProvider(implicitConfigurationProviderName).isPresent()) {
            ExtensionModel extensionModel2 = extensionModel;
            synchronized (extensionModel2) {
                if (!this.extensionRegistry.getConfigurationProvider(implicitConfigurationProviderName).isPresent()) {
                    this.registerConfigurationProvider(this.implicitConfigurationProviderFactory.createImplicitConfigurationProvider(extensionModel, implicitConfigurationModel, muleEvent, this.muleContext));
                }
            }
        }
    }

    private Optional<ConfigurationModel> getConfigurationModelForExtension(ExtensionModel extensionModel, Set<ConfigurationModel> assignableConfigurationModels) {
        List implicitConfigurationModels = assignableConfigurationModels.stream().filter(ExtensionModelUtils::canBeUsedImplicitly).collect(Collectors.toList());
        if (implicitConfigurationModels.isEmpty()) {
            return Optional.empty();
        }
        if (implicitConfigurationModels.size() == 1) {
            return Optional.ofNullable(implicitConfigurationModels.get(0));
        }
        throw new IllegalStateException(String.format("No configuration can be inferred for extension '%s'", extensionModel.getName()));
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.extensionRegistry.getExtensions();
    }

    @Override
    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionRegistry.getExtension(extensionName);
    }

    private ConfigurationExpirationMonitor newConfigurationExpirationMonitor() {
        Time freq = this.getConfigurationExpirationFrequency();
        return DefaultConfigurationExpirationMonitor.Builder.newBuilder(this.extensionRegistry, this.muleContext).runEvery(freq.getTime(), freq.getUnit()).onExpired((key, object) -> this.disposeConfiguration((String)key, (ConfigurationInstance)object)).build();
    }

    private void disposeConfiguration(String key, ConfigurationInstance configuration) {
        try {
            LifecycleUtils.stopIfNeeded(configuration);
            LifecycleUtils.disposeIfNeeded(configuration, LOGGER);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Could not dispose expired dynamic config of key '%s' and type %s", key, configuration.getClass().getName()), (Throwable)e);
        }
    }

    private Time getConfigurationExpirationFrequency() {
        ExtensionConfig extensionConfig = this.muleContext.getConfiguration().getExtension(ExtensionConfig.class);
        Time defaultFreq = new Time(5L, TimeUnit.MINUTES);
        if (extensionConfig != null) {
            return extensionConfig.getDynamicConfigExpirationFrequency().orElse(defaultFreq);
        }
        return defaultFreq;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

