/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lifecycle.SimpleLifecycleManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.lifecycle.DefaultLifecycleManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifecycleAwareConfigurationProvider
extends AbstractAnnotatedObject
implements ConfigurationProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleAwareConfigurationProvider.class);
    private final String name;
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final List<ConfigurationInstance> configurationInstances = new LinkedList<ConfigurationInstance>();
    private final ClassLoader extensionClassLoader;
    protected final SimpleLifecycleManager lifecycleManager;
    protected final MuleContext muleContext;

    public LifecycleAwareConfigurationProvider(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        this.name = name;
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
        this.muleContext = muleContext;
        this.extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        this.lifecycleManager = new DefaultLifecycleManager<LifecycleAwareConfigurationProvider>(String.format("%s-%s", this.getClass().getName(), this.getName()), this);
    }

    @Override
    public void initialise() throws InitialisationException {
        ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
            this.lifecycleManager.fireInitialisePhase((phaseName, object) -> {
                for (ConfigurationInstance configurationInstance : this.configurationInstances) {
                    LifecycleUtils.initialiseIfNeeded(configurationInstance, true, this.muleContext);
                }
                this.doInitialise();
            });
            return null;
        }, InitialisationException.class, e -> {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        });
    }

    protected void doInitialise() {
    }

    @Override
    public void start() throws MuleException {
        ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
            this.lifecycleManager.fireStartPhase((phaseName, object) -> {
                for (ConfigurationInstance configurationInstance : this.configurationInstances) {
                    this.startConfig(configurationInstance);
                }
            });
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public void stop() throws MuleException {
        ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
            this.lifecycleManager.fireStopPhase((phaseName, object) -> {
                for (ConfigurationInstance configurationInstance : this.configurationInstances) {
                    LifecycleUtils.stopIfNeeded(configurationInstance);
                }
            });
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public void dispose() {
        try {
            ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> {
                this.lifecycleManager.fireDisposePhase((phaseName, object) -> {
                    for (ConfigurationInstance configurationInstance : this.configurationInstances) {
                        LifecycleUtils.disposeIfNeeded(configurationInstance, LOGGER);
                    }
                });
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not dispose configuration provider of name " + this.getName(), (Throwable)e);
        }
    }

    protected void registerConfiguration(ConfigurationInstance configuration) {
        this.configurationInstances.add(configuration);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationModel getConfigurationModel() {
        return this.configurationModel;
    }

    @Override
    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    protected void startConfig(ConfigurationInstance config) throws MuleException {
        LifecycleUtils.startIfNeeded(config);
    }

    protected ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }
}

