/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ReactorCompletionCallback;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class ReactiveOperationExecutionWrapper
implements OperationExecutor,
OperationArgumentResolverFactory,
Lifecycle,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveOperationExecutionWrapper.class);
    private final OperationExecutor delegate;
    private MuleContext muleContext;

    public ReactiveOperationExecutionWrapper(OperationExecutor delegate) {
        this.delegate = delegate;
    }

    @Override
    public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
        if (executionContext.getComponentModel().isBlocking()) {
            return this.delegate.execute(executionContext);
        }
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        return Mono.create(sink -> {
            ReactorCompletionCallback callback = new ReactorCompletionCallback((MonoSink<Object>)sink);
            context.setVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM", callback);
            try {
                this.delegate.execute(executionContext);
            }
            catch (Throwable t) {
                sink.error(Exceptions.wrapFatal(t));
            }
        });
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Function<ExecutionContext<OperationModel>, Map<String, Object>> createArgumentResolver(OperationModel operationModel) {
        return this.delegate instanceof OperationArgumentResolverFactory ? ((OperationArgumentResolverFactory)((Object)this.delegate)).createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

