/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.TargetType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import reactor.core.publisher.Mono;

public class PagedOperationMessageProcessor
extends OperationMessageProcessor {
    private final ExtensionConnectionSupplier connectionSupplier;

    public PagedOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, TargetType targetType, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager, ExtensionConnectionSupplier connectionSupplier) {
        super(extensionModel, operationModel, configurationProvider, target, targetType, resolverSet, cursorProviderFactory, extensionManager, policyManager);
        this.connectionSupplier = connectionSupplier;
    }

    @Override
    protected Mono<InternalEvent> doProcess(InternalEvent event, ExecutionContextAdapter<OperationModel> operationContext) {
        return super.doProcess(event, operationContext).map(resultEvent -> {
            PagingProvider pagingProvider = this.getTarget().map(target -> this.getPagingProvider(resultEvent.getVariables().get(target).getValue())).orElseGet(() -> this.getPagingProvider(resultEvent.getMessage()));
            if (pagingProvider == null) {
                throw new IllegalStateException("Obtained paging delegate cannot be null");
            }
            PagingProviderProducer producer = new PagingProviderProducer(pagingProvider, operationContext.getConfiguration().get(), operationContext, this.connectionSupplier);
            ListConsumer consumer = new ListConsumer(producer);
            return this.returnDelegate.asReturnValue(new ConsumerStreamingIterator(consumer), operationContext);
        }).onErrorMap(Exceptions::wrapFatal);
    }

    private PagingProvider getPagingProvider(Object target) {
        return target instanceof Message ? (PagingProvider)((Message)target).getPayload().getValue() : (PagingProvider)target;
    }
}

