/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.meta.TargetType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.AbstractReturnDelegate;

final class TargetReturnDelegate
extends AbstractReturnDelegate {
    private final String target;
    private final TargetType targetType;

    TargetReturnDelegate(String target, TargetType targetType, ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        super(componentModel, cursorProviderFactory, muleContext);
        this.target = target;
        this.targetType = targetType;
    }

    @Override
    public InternalEvent asReturnValue(Object value, ExecutionContextAdapter operationContext) {
        InternalEvent.Builder builder = InternalEvent.builder(operationContext.getEvent());
        if (this.targetType == TargetType.MESSAGE) {
            builder.addVariable(this.target, this.toMessage(value, operationContext));
        } else {
            Object targetValue = MessageUtils.unwrapResultIfNecessary(value);
            builder.addVariable(this.target, targetValue, DataType.builder().fromObject(targetValue).mediaType(this.resolveMediaType(value, operationContext)).build());
        }
        return builder.build();
    }
}

