/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.exception.ErrorTypeLocator;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessingManager;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.config.ConfiguredComponent;
import org.mule.runtime.extension.api.runtime.source.ParameterizedSource;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionHandlerManager;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalSourceException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBasedParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionMessageSource
extends ExtensionComponent<SourceModel>
implements MessageSource,
ExceptionCallback,
ParameterizedSource,
ConfiguredComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionMessageSource.class);
    @Inject
    private MessageProcessingManager messageProcessingManager;
    @Inject
    private SchedulerService schedulerService;
    private final SourceModel sourceModel;
    private final SourceAdapterFactory sourceAdapterFactory;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final ExceptionHandlerManager exceptionEnricherManager;
    private SourceConnectionManager sourceConnectionManager;
    private Processor messageProcessor;
    private LazyValue<TransactionConfig> transactionConfig = new LazyValue<Supplier<TransactionConfig>>(this::buildTransactionConfig);
    private SourceAdapter sourceAdapter;
    private Scheduler retryScheduler;
    private Scheduler flowTriggerScheduler;
    private final ExtensionTransactionFactory transactionFactory = new ExtensionTransactionFactory();
    private AtomicBoolean started = new AtomicBoolean(false);

    public ExtensionMessageSource(ExtensionModel extensionModel, SourceModel sourceModel, SourceAdapterFactory sourceAdapterFactory, ConfigurationProvider configurationProvider, RetryPolicyTemplate retryPolicyTemplate, CursorProviderFactory cursorProviderFactory, ExtensionManager managerAdapter) {
        super(extensionModel, sourceModel, configurationProvider, cursorProviderFactory, managerAdapter);
        this.sourceModel = sourceModel;
        this.sourceAdapterFactory = sourceAdapterFactory;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.exceptionEnricherManager = new ExceptionHandlerManager(extensionModel, sourceModel);
    }

    private synchronized void createSource() throws Exception {
        if (this.sourceAdapter == null) {
            this.sourceAdapter = this.sourceAdapterFactory.createAdapter(this.getConfiguration(org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext)), this.createSourceCallbackFactory(), this.getLocation(), this.sourceConnectionManager);
            this.muleContext.getInjector().inject(this.sourceAdapter);
        }
    }

    private void startSource() throws MuleException {
        try {
            this.retryPolicyTemplate.execute(new SourceRetryCallback(), this.retryScheduler);
        }
        catch (Throwable e) {
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new MuleRuntimeException(e);
        }
    }

    private void stopSource() throws MuleException {
        if (this.sourceAdapter != null) {
            try {
                this.sourceAdapter.stop();
            }
            catch (Exception e) {
                throw new DefaultMuleException(String.format("Found exception stopping source '%s' of root component '%s'", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), (Throwable)e);
            }
        }
    }

    @Override
    public Optional<ConfigurationInstance> getConfigurationInstance() {
        return this.sourceAdapter.getConfigurationInstance();
    }

    private SourceCallbackFactory createSourceCallbackFactory() {
        return completionHandlerFactory -> DefaultSourceCallback.builder().setExceptionCallback(this).setSourceModel(this.sourceModel).setConfigurationInstance(this.getConfigurationInstance().orElse(null)).setTransactionConfig(this.transactionConfig.get()).setSource(this).setListener(this.messageProcessor).setProcessingManager(this.messageProcessingManager).setMuleContext(this.muleContext).setProcessContextSupplier(this::createProcessingContext).setCursorStreamProviderFactory(this.getCursorProviderFactory()).setCompletionHandlerFactory(completionHandlerFactory).build();
    }

    public void onException(Throwable exception) {
        Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(exception = this.exceptionEnricherManager.process(exception));
        if (connectionException.isPresent()) {
            try {
                LOGGER.warn(String.format("Message source '%s' on root component '%s' threw exception. Restarting...", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), exception);
                this.restart();
            }
            catch (Throwable e) {
                this.notifyExceptionAndShutDown(e);
            }
        } else {
            this.notifyExceptionAndShutDown(exception);
        }
    }

    private void notifyExceptionAndShutDown(Throwable exception) {
        LOGGER.error(String.format("Message source on root component '%s' threw exception. Shutting down it forever...", this.getLocation().getRootContainerName()), exception);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() throws MuleException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.get()) {
                this.stopSource();
                this.disposeSource();
                this.startSource();
            } else {
                LOGGER.warn(String.format("Message source '%s' on root component '%s' is stopped. Not doing restart", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws MuleException {
        if (this.retryScheduler == null) {
            this.retryScheduler = this.schedulerService.ioScheduler();
        }
        if (this.flowTriggerScheduler == null) {
            this.flowTriggerScheduler = this.schedulerService.cpuLightScheduler();
        }
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.startSource();
            this.started.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws MuleException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.started.set(false);
            try {
                this.stopSource();
            }
            finally {
                this.stopSchedulers();
            }
        }
    }

    @Override
    public void doDispose() {
        this.disposeSource();
    }

    private void shutdown() {
        try {
            LifecycleUtils.stopIfNeeded(this);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to stop source '%s' on flow '%s'", this.sourceAdapter.getName(), this.getLocation().getRootContainerName()), (Throwable)e);
        }
        LifecycleUtils.disposeIfNeeded(this, LOGGER);
    }

    private void stopSchedulers() {
        if (this.retryScheduler != null) {
            try {
                this.retryScheduler.stop();
            }
            finally {
                this.retryScheduler = null;
            }
        }
        if (this.flowTriggerScheduler != null) {
            try {
                this.flowTriggerScheduler.stop();
            }
            finally {
                this.flowTriggerScheduler = null;
            }
        }
    }

    private void disposeSource() {
        LifecycleUtils.disposeIfNeeded(this.sourceAdapter, LOGGER);
        this.sourceAdapter = null;
    }

    private TransactionConfig buildTransactionConfig() {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.sourceAdapter.getTransactionalAction()));
        transactionConfig.setMuleContext(this.muleContext);
        transactionConfig.setFactory(this.transactionFactory);
        return transactionConfig;
    }

    SourceConnectionManager getSourceConnectionManager() {
        return this.sourceConnectionManager;
    }

    private MessageProcessContext createProcessingContext() {
        return new MessageProcessContext(){

            @Override
            public boolean supportsAsynchronousProcessing() {
                return true;
            }

            @Override
            public MessageSource getMessageSource() {
                return ExtensionMessageSource.this;
            }

            @Override
            public Scheduler getFlowExecutionExecutor() {
                return ExtensionMessageSource.this.flowTriggerScheduler;
            }

            @Override
            public Optional<TransactionConfig> getTransactionConfig() {
                return ExtensionMessageSource.this.sourceModel.isTransactional() ? Optional.of(ExtensionMessageSource.this.transactionConfig.get()) : Optional.empty();
            }

            @Override
            public ClassLoader getExecutionClassLoader() {
                return ExtensionMessageSource.this.muleContext.getExecutionClassLoader();
            }

            @Override
            public ErrorTypeLocator getErrorTypeLocator() {
                return ExtensionMessageSource.this.muleContext.getErrorTypeLocator();
            }
        };
    }

    @Override
    public void setListener(Processor listener) {
        this.messageProcessor = listener;
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getSourceModel(this.sourceModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getSourceModel(this.sourceModel.getName()).isPresent()) {
            throw new IllegalSourceException(String.format("Root component '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.getLocation().getRootContainerName(), this.sourceModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        return new ObjectBasedParameterValueResolver(this.sourceAdapter.getDelegate(), this.sourceModel);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.sourceConnectionManager = new SourceConnectionManager(this.connectionManager);
        try {
            this.createSource();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public Map<String, Object> getInitialisationParameters() {
        try {
            return ImmutableMap.copyOf(MuleExtensionUtils.toMap(this.sourceAdapterFactory.getSourceParameters(), org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent()));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not resolve parameters message source at location '%s'", this.getLocation().toString()), e));
        }
    }

    private class SourceRetryCallback
    implements RetryCallback {
        private SourceRetryCallback() {
        }

        @Override
        public void doWork(RetryContext context) throws Exception {
            try {
                ExtensionMessageSource.this.createSource();
                ExtensionMessageSource.this.sourceAdapter.initialise();
                ExtensionMessageSource.this.sourceAdapter.start();
            }
            catch (Exception e) {
                ExtensionMessageSource.this.stopSource();
                ExtensionMessageSource.this.disposeSource();
                Throwable throwable = ExtensionMessageSource.this.exceptionEnricherManager.process(e);
                Optional<ConnectionException> connectionException = ExceptionUtils.extractConnectionException(throwable);
                if (connectionException.isPresent()) {
                    throwable = connectionException.get();
                }
                throw throwable instanceof Exception ? (Exception)throwable : new MuleRuntimeException(throwable);
            }
        }

        @Override
        public String getWorkDescription() {
            return "Message Source Reconnection";
        }

        @Override
        public Object getWorkOwner() {
            return ExtensionMessageSource.this;
        }
    }
}

