/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.tx.TransactionHandle;

public class DefaultTransactionHandle
implements TransactionHandle {
    private final TransactionalConnection connection;
    private final AtomicBoolean txResolved = new AtomicBoolean(false);

    public DefaultTransactionHandle(TransactionalConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    @Override
    public void commit() throws TransactionException {
        this.resolveTxAs(this.connection::commit);
    }

    @Override
    public void rollback() throws TransactionException {
        this.resolveTxAs(this.connection::rollback);
    }

    private void resolveTxAs(CheckedRunnable task) {
        if (this.txResolved.compareAndSet(false, true)) {
            task.run();
            TransactionCoordination.getInstance().clear();
        }
    }
}

