/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.ServiceProviderResolutionHelper;
import org.mule.runtime.module.service.ServiceResolutionError;
import org.mule.runtime.module.service.ServiceResolver;

public class ReflectionServiceResolver
implements ServiceResolver {
    private final ServiceProviderResolutionHelper serviceProviderResolutionHelper;

    public ReflectionServiceResolver(ServiceProviderResolutionHelper serviceProviderResolutionHelper) {
        Preconditions.checkArgument(serviceProviderResolutionHelper != null, "serviceProviderResolutionHelper cannot be null");
        this.serviceProviderResolutionHelper = serviceProviderResolutionHelper;
    }

    @Override
    public List<Pair<ArtifactClassLoader, Service>> resolveServices(List<Pair<ArtifactClassLoader, ServiceProvider>> serviceProviders) throws ServiceResolutionError {
        List<DependencyAwareServiceProvider> dependencyAwareServiceProviders = this.createDependencyAwareServiceProviders(serviceProviders);
        LinkedHashMap<Class<? extends Service>, Pair<ArtifactClassLoader, ServiceDefinition>> registeredServices = new LinkedHashMap<Class<? extends Service>, Pair<ArtifactClassLoader, ServiceDefinition>>();
        LinkedList<DependencyAwareServiceProvider> unresolvedServiceProviders = new LinkedList<DependencyAwareServiceProvider>(dependencyAwareServiceProviders);
        LinkedList<DependencyAwareServiceProvider> resolvedServiceProviders = new LinkedList<DependencyAwareServiceProvider>();
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedServiceProviders.size();
            LinkedList<DependencyAwareServiceProvider> pendingUnresolvedServices = new LinkedList<DependencyAwareServiceProvider>();
            for (DependencyAwareServiceProvider dependencyAwareServiceProvider : unresolvedServiceProviders) {
                List<ServiceDefinition> serviceDefinitions;
                if (this.isResolvedService(dependencyAwareServiceProvider, serviceDefinitions = registeredServices.values().stream().map(pair -> (ServiceDefinition)pair.getSecond()).collect(Collectors.toList()))) {
                    this.serviceProviderResolutionHelper.injectInstance(dependencyAwareServiceProvider.serviceProvider, serviceDefinitions);
                    for (ServiceDefinition serviceDefinition : dependencyAwareServiceProvider.providedServices()) {
                        registeredServices.put(serviceDefinition.getServiceClass(), new Pair<ArtifactClassLoader, ServiceDefinition>(dependencyAwareServiceProvider.getArtifactClassLoader(), serviceDefinition));
                    }
                    resolvedServiceProviders.add(dependencyAwareServiceProvider);
                    continue;
                }
                pendingUnresolvedServices.add(dependencyAwareServiceProvider);
            }
            unresolvedServiceProviders = pendingUnresolvedServices;
            continueResolution = resolvedServiceProviders.size() > initialResolvedCount;
        }
        if (!unresolvedServiceProviders.isEmpty()) {
            HashSet<Class<? extends Service>> dependencies = new HashSet<Class<? extends Service>>();
            for (DependencyAwareServiceProvider dependencyAwareServiceProvider : unresolvedServiceProviders) {
                dependencies.addAll(dependencyAwareServiceProvider.getDependencies());
            }
            throw new ServiceResolutionError("Unable to resolve core service dependencies. Missing some of: " + dependencies);
        }
        ArrayList<Pair<ArtifactClassLoader, Service>> servicePairs = new ArrayList<Pair<ArtifactClassLoader, Service>>();
        for (Pair pair2 : registeredServices.values()) {
            servicePairs.add(new Pair(pair2.getFirst(), ((ServiceDefinition)pair2.getSecond()).getService()));
        }
        return servicePairs;
    }

    private List<DependencyAwareServiceProvider> createDependencyAwareServiceProviders(List<Pair<ArtifactClassLoader, ServiceProvider>> serviceProviders) {
        ArrayList<DependencyAwareServiceProvider> result = new ArrayList<DependencyAwareServiceProvider>(serviceProviders.size());
        for (Pair<ArtifactClassLoader, ServiceProvider> pair : serviceProviders) {
            result.add(new DependencyAwareServiceProvider(pair.getFirst(), pair.getSecond(), this.serviceProviderResolutionHelper.findServiceDependencies(pair.getSecond())));
        }
        result.sort(Comparator.comparing(p -> p.getClass().getName()));
        return result;
    }

    private boolean isResolvedService(DependencyAwareServiceProvider dependencyAwareServiceProvider, Collection<ServiceDefinition> resolvedServices) {
        boolean resolvedCoreExtension = dependencyAwareServiceProvider.dependencies.isEmpty();
        if (!resolvedCoreExtension && this.satisfiedDependencies(dependencyAwareServiceProvider.dependencies, resolvedServices)) {
            resolvedCoreExtension = true;
        }
        return resolvedCoreExtension;
    }

    private boolean satisfiedDependencies(List<Class<? extends Service>> dependencies, Collection<ServiceDefinition> resolvedServices) {
        boolean resolvedDependency = true;
        for (Class<? extends Service> dependency : dependencies) {
            resolvedDependency = false;
            for (ServiceDefinition registeredService : resolvedServices) {
                if (!registeredService.getServiceClass().isAssignableFrom(dependency)) continue;
                resolvedDependency = true;
            }
            if (resolvedDependency) continue;
            break;
        }
        return resolvedDependency;
    }

    private final class DependencyAwareServiceProvider
    implements ServiceProvider {
        private final ServiceProvider serviceProvider;
        private final List<Class<? extends Service>> dependencies;
        private final ArtifactClassLoader artifactClassLoader;

        DependencyAwareServiceProvider(ArtifactClassLoader artifactClassLoader, ServiceProvider serviceProvider, List<Class<? extends Service>> dependencies) {
            this.artifactClassLoader = artifactClassLoader;
            this.serviceProvider = serviceProvider;
            this.dependencies = dependencies;
        }

        @Override
        public List<ServiceDefinition> providedServices() {
            return this.serviceProvider.providedServices();
        }

        List<Class<? extends Service>> getDependencies() {
            return this.dependencies;
        }

        public ArtifactClassLoader getArtifactClassLoader() {
            return this.artifactClassLoader;
        }
    }
}

