/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal;

import java.io.IOException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.module.tls.internal.DefaultTlsContextFactory;

public class DefaultTlsContextFactoryBuilder
implements TlsContextFactoryBuilder {
    private TlsContextFactory defaultTlsContextFactory;
    private DefaultTlsContextFactory tlsContextFactory = new DefaultTlsContextFactory();
    private String trustStorePath;
    private String keyStorePath;

    public DefaultTlsContextFactoryBuilder(TlsContextFactory defaultTlsContextFactory) {
        this.defaultTlsContextFactory = defaultTlsContextFactory;
    }

    @Override
    public TlsContextFactoryBuilder name(String name) {
        this.tlsContextFactory.setName(name);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder enabledProtocols(String protocols) {
        this.tlsContextFactory.setEnabledProtocols(protocols);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder enabledCipherSuites(String cipherSuites) {
        this.tlsContextFactory.setEnabledCipherSuites(cipherSuites);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder trustStorePath(String path) {
        this.trustStorePath = path;
        return this;
    }

    @Override
    public TlsContextFactoryBuilder trustStorePassword(String password) {
        this.tlsContextFactory.setTrustStorePassword(password);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder trustStoreType(String type) {
        this.tlsContextFactory.setTrustStoreType(type);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder insecureTrustStore(boolean insecure) {
        this.tlsContextFactory.setTrustStoreInsecure(insecure);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder trustStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setTrustManagerAlgorithm(algorithm);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyStorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyStorePassword(String password) {
        this.tlsContextFactory.setKeyStorePassword(password);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyAlias(String alias) {
        this.tlsContextFactory.setKeyAlias(alias);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyPassword(String password) {
        this.tlsContextFactory.setKeyPassword(password);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyStoreType(String type) {
        this.tlsContextFactory.setKeyStoreType(type);
        return this;
    }

    @Override
    public TlsContextFactoryBuilder keyStoreAlgorithm(String algorithm) {
        this.tlsContextFactory.setKeyManagerAlgorithm(algorithm);
        return this;
    }

    @Override
    public TlsContextFactory build() throws CreateException {
        try {
            if (this.trustStorePath != null) {
                this.tlsContextFactory.setTrustStorePath(this.trustStorePath);
            }
            if (this.keyStorePath != null) {
                this.tlsContextFactory.setKeyStorePath(this.keyStorePath);
            }
            this.tlsContextFactory.initialise();
        }
        catch (IOException e) {
            throw new CreateException(I18nMessageFactory.createStaticMessage(e.getMessage()), e, this.tlsContextFactory);
        }
        catch (InitialisationException e) {
            throw new CreateException(e.getI18nMessage(), e, this.tlsContextFactory);
        }
        return this.tlsContextFactory;
    }

    @Override
    public TlsContextFactory buildDefault() {
        return this.defaultTlsContextFactory;
    }
}

