/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.util.CopyFileVisitor;

public class ContentGenerator {
    private static final String CLASSLOADER_MODEL_FILE_NAME = "classloader-model.json";
    private String groupId;
    private String artifactId;
    private String version;
    private PackagingType packagingType;
    private Path projectBaseFolder;
    private Path projectTargetFolder;

    public ContentGenerator(String groupId, String artifactId, String version, PackagingType packagingType, Path projectBaseFolder, Path projectTargetFolder) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)groupId), (Object)"The groupId must not be null nor empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)artifactId), (Object)"The artifactId must not be null nor empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)version), (Object)"The version must not be null nor empty");
        Preconditions.checkArgument((packagingType != null ? 1 : 0) != 0, (Object)"The packagingType must not be null");
        this.checkPathExist(projectBaseFolder);
        this.checkPathExist(projectTargetFolder);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packagingType = packagingType;
        this.projectBaseFolder = projectBaseFolder;
        this.projectTargetFolder = projectTargetFolder;
    }

    public void createContent() throws IOException {
        this.createSrcFolderContent();
        this.createMetaInfMuleSourceFolderContent();
        this.createDescriptors();
    }

    public void createSrcFolderContent() throws IOException {
        Path originPath = this.packagingType.getSourceFolderLocation(this.projectBaseFolder);
        Path destinationPath = this.projectTargetFolder.resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null));
    }

    public void createTestFolderContent() throws IOException {
        Path originPath = this.packagingType.getTestSourceFolderLocation(this.projectBaseFolder);
        Path destinationPath = this.projectTargetFolder.resolve("test-mule").resolve(originPath.getFileName());
        this.copyContent(originPath, destinationPath, Optional.ofNullable(null), false, true);
    }

    public void createMetaInfMuleSourceFolderContent() throws IOException {
        Path originPath = this.projectBaseFolder;
        Path destinationPath = this.projectTargetFolder.resolve("META-INF").resolve("mule-src").resolve(this.artifactId);
        ArrayList<Path> exclusions = new ArrayList<Path>();
        exclusions.add(this.projectBaseFolder.resolve("target"));
        this.copyContent(originPath, destinationPath, Optional.of(exclusions));
    }

    public void createDescriptors() throws IOException {
        this.copyPomFile();
        this.createPomProperties();
        this.copyDescriptorFile();
    }

    public void createApplicationClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel) {
        File destinationFolder = this.projectTargetFolder.resolve("META-INF").resolve("mule-artifact").toFile();
        ContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, destinationFolder);
    }

    public static ClassLoaderModel createClassLoaderModelFromJson(File classLoaderModelDescriptor) {
        try {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
            FileReader reader = new FileReader(classLoaderModelDescriptor);
            ClassLoaderModel classLoaderModel = (ClassLoaderModel)gson.fromJson((Reader)reader, ClassLoaderModel.class);
            ((Reader)reader).close();
            return classLoaderModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloadermodel.json", e);
        }
    }

    private void copyPomFile() throws IOException {
        Path originPath = this.projectBaseFolder.resolve("pom.xml");
        Path destinationPath = this.projectTargetFolder.resolve("META-INF").resolve("maven").resolve(this.groupId).resolve(this.artifactId);
        String destinationFileName = originPath.getFileName().toString();
        this.copyFile(originPath, destinationPath, destinationFileName);
    }

    private void copyDescriptorFile() throws IOException {
        Path originPath = this.projectBaseFolder.resolve("mule-artifact.json");
        Path destinationPath = this.projectTargetFolder.resolve("META-INF").resolve("mule-artifact");
        String destinationFileName = originPath.getFileName().toString();
        this.copyFile(originPath, destinationPath, destinationFileName);
    }

    protected void createPomProperties() {
        Path pomPropertiesDestinationPath = this.projectTargetFolder.resolve("META-INF").resolve("maven").resolve(this.groupId).resolve(this.artifactId);
        this.checkPathExist(pomPropertiesDestinationPath);
        Path pomPropertiesFilePath = pomPropertiesDestinationPath.resolve("pom.properties");
        try {
            PrintWriter writer = new PrintWriter(pomPropertiesFilePath.toString(), "UTF-8");
            writer.println("version=" + this.version);
            writer.println("groupId=" + this.groupId);
            writer.println("artifactId=" + this.artifactId);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create pom.properties", e);
        }
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions) throws IOException {
        this.copyContent(originPath, destinationPath, exclusions, true, true);
    }

    private void copyContent(Path originPath, Path destinationPath, Optional<List<Path>> exclusions, Boolean validateOrigin, Boolean validateDestination) throws IOException {
        if (validateOrigin.booleanValue()) {
            this.checkPathExist(originPath);
        }
        if (validateDestination.booleanValue()) {
            this.checkPathExist(destinationPath);
        }
        CopyFileVisitor visitor = new CopyFileVisitor(originPath.toFile(), destinationPath.toFile());
        exclusions.ifPresent(e -> visitor.setExclusions((List<Path>)e));
        Files.walkFileTree(originPath, visitor);
    }

    private void copyFile(Path originPath, Path destinationPath, String destinationFileName) throws IOException {
        this.checkPathExist(originPath);
        this.checkPathExist(destinationPath);
        Files.copy(originPath, destinationPath.resolve(destinationFileName), StandardCopyOption.REPLACE_EXISTING);
    }

    private void checkPathExist(Path path) {
        Preconditions.checkArgument((boolean)path.toFile().exists(), (Object)("The path: " + path.toString() + " should exits"));
    }

    public static File createClassLoaderModelJsonFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        File destinationFile = new File(destinationFolder, CLASSLOADER_MODEL_FILE_NAME);
        try {
            destinationFile.createNewFile();
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(destinationFile.getAbsolutePath());
            ClassLoaderModel parameterizedClassloaderModel = classLoaderModel.getParametrizedUriModel();
            gson.toJson((Object)parameterizedClassloaderModel, (Appendable)writer);
            ((Writer)writer).close();
            return destinationFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloadermodel.json", e);
        }
    }
}

