/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.MuleArchiver;
import org.mule.tools.api.packager.packaging.PackagingType;

public class PackageBuilder {
    private File muleFolder = null;
    private File policyFolder = null;
    private File classesFolder = null;
    private File repositoryFolder = null;
    private File mavenFolder = null;
    private File muleSrcFolder = null;
    private File muleArtifactFolder = null;
    private List<File> rootResources = new ArrayList<File>();
    private File destinationFile;
    private MuleArchiver archiver = null;

    public MuleArchiver getMuleArchiver() {
        if (this.archiver == null) {
            this.archiver = new MuleArchiver();
        }
        return this.archiver;
    }

    public PackageBuilder withArchiver(MuleArchiver archiver) {
        Preconditions.checkNotNull((Object)((Object)archiver), (Object)"The org.mule.tools.artifact.org.mule.tools.artifact.archiver must not be null");
        this.archiver = archiver;
        return this;
    }

    public PackageBuilder withClasses(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.classesFolder = folder;
        return this;
    }

    public PackageBuilder withMule(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0);
        this.muleFolder = folder;
        return this;
    }

    public PackageBuilder withPolicy(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0);
        this.policyFolder = folder;
        return this;
    }

    public PackageBuilder withMaven(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.mavenFolder = folder;
        return this;
    }

    public PackageBuilder withMuleSrc(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleSrcFolder = folder;
        return this;
    }

    public PackageBuilder withMuleArtifact(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.muleArtifactFolder = folder;
        return this;
    }

    public PackageBuilder withRepository(File folder) {
        Preconditions.checkArgument((folder != null ? 1 : 0) != 0, (Object)"The folder must not be null");
        this.repositoryFolder = folder;
        return this;
    }

    public PackageBuilder withRootResource(File resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The resource must not be null");
        this.rootResources.add(resource);
        return this;
    }

    public PackageBuilder withDestinationFile(File file) {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"The file must not be null");
        Preconditions.checkArgument((!file.exists() ? 1 : 0) != 0, (Object)"The file must not be duplicated");
        this.destinationFile = file;
        return this;
    }

    public PackageBuilder fromWorkingDirectory(Path workingDirectory) {
        return this.withClasses(workingDirectory.resolve("classes").toFile()).withMule(workingDirectory.resolve("mule").toFile()).withPolicy(workingDirectory.resolve("policy").toFile()).withMaven(workingDirectory.resolve("META-INF").resolve("maven").toFile()).withMuleArtifact(workingDirectory.resolve("META-INF").resolve("mule-artifact").toFile()).withMuleSrc(workingDirectory.resolve("META-INF").resolve("mule-src").toFile()).withRepository(workingDirectory.resolve("repository").toFile());
    }

    public void createDeployableFile() throws IOException {
        this.runPrePackageValidations();
        MuleArchiver archiver = this.getMuleArchiver();
        if (null != this.muleFolder && this.muleFolder.exists() && this.muleFolder.isDirectory()) {
            archiver.addMule(this.muleFolder, null, null);
        }
        if (null != this.policyFolder && this.policyFolder.exists() && this.policyFolder.isDirectory()) {
            archiver.addPolicy(this.policyFolder, null, null);
        }
        if (null != this.classesFolder && this.classesFolder.exists() && this.classesFolder.isDirectory()) {
            archiver.addClasses(this.classesFolder, null, null);
        }
        if (null != this.mavenFolder && this.mavenFolder.exists() && this.mavenFolder.isDirectory()) {
            archiver.addMaven(this.mavenFolder, null, null);
        }
        if (null != this.muleArtifactFolder && this.muleArtifactFolder.exists() && this.muleArtifactFolder.isDirectory()) {
            archiver.addMuleArtifact(this.muleArtifactFolder, null, null);
        }
        if (null != this.muleSrcFolder && this.muleSrcFolder.exists() && this.muleSrcFolder.isDirectory()) {
            archiver.addMuleSrc(this.muleSrcFolder, null, null);
        }
        if (null != this.repositoryFolder && this.repositoryFolder.exists() && this.repositoryFolder.isDirectory()) {
            archiver.addRepository(this.repositoryFolder, null, null);
        }
        archiver.setDestFile(this.destinationFile);
        archiver.createArchive();
    }

    public void createMuleApp(File destinationFile, String originFolder, PackagingType packagingType, boolean onlyMuleSources, boolean lightweightPackage, boolean attachMuleSources) throws ArchiverException, IOException {
        PackageBuilder builder = this.withDestinationFile(destinationFile);
        if (!onlyMuleSources) {
            builder.withClasses(new File(originFolder + File.separator + "classes")).withMaven(new File(originFolder + File.separator + "META-INF" + File.separator + "maven")).withMuleArtifact(new File(originFolder + File.separator + "META-INF" + File.separator + "mule-artifact"));
            if (PackagingType.MULE_POLICY.equals((Object)packagingType)) {
                builder.withPolicy(new File(originFolder + File.separator + "policy"));
            } else {
                builder.withMule(new File(originFolder + File.separator + "mule"));
            }
            if (!lightweightPackage) {
                builder.withRepository(new File(originFolder + File.separator + "repository"));
            }
            if (attachMuleSources) {
                builder.withMuleSrc(new File(originFolder + File.separator + "META-INF" + File.separator + "mule-src"));
            }
        } else {
            builder.withMuleSrc(new File(originFolder + File.separator + "META-INF" + File.separator + "mule-src"));
        }
        builder.createDeployableFile();
    }

    private void runPrePackageValidations() {
        Preconditions.checkArgument((this.destinationFile != null ? 1 : 0) != 0, (Object)"The destination file has not been set");
    }
}

