/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.structure.FolderNames;

public class ProjectFoldersGenerator {
    private String groupId;
    private String artifactId;
    private PackagingType packagingType;

    public ProjectFoldersGenerator(String groupId, String artifactId, PackagingType packagingType) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)groupId), (Object)"The groupId must not be null nor empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)artifactId), (Object)"The artifactId must not be null nor empty");
        Preconditions.checkArgument((packagingType != null ? 1 : 0) != 0, (Object)"The packagingType must not be null");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packagingType = packagingType;
    }

    public void generate(Path targetFolder) {
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), this.packagingType.getSourceFolderName());
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), FolderNames.TEST_MULE.value(), FolderNames.MUNIT.value());
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), FolderNames.META_INF.value(), FolderNames.MULE_SRC.value(), this.artifactId);
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), FolderNames.META_INF.value(), FolderNames.MAVEN.value(), this.groupId, this.artifactId);
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), FolderNames.META_INF.value(), FolderNames.MULE_ARTIFACT.value());
        this.createFolderIfNecessary(targetFolder.toAbsolutePath().toString(), FolderNames.REPOSITORY.value());
    }

    private void createFolderIfNecessary(String ... folderPath) {
        String path = StringUtils.join((Object[])folderPath, (String)File.separator);
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }
}

