/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.util.DefaultMavenRepositoryLayoutUtils;
import org.mule.tools.api.packager.ContentGenerator;

public class ArtifactInstaller {
    private static final String POM_FILE_NAME = "pom.xml";
    private Log log;

    public ArtifactInstaller(Log log) {
        this.log = log;
    }

    public void installArtifact(File repositoryFile, Artifact artifact, Optional<ClassLoaderModel> classLoaderModel) throws IOException {
        Preconditions.checkArgument((artifact != null ? 1 : 0) != 0, (Object)"Artifact to be installed should not be null");
        File artifactFolderDestination = DefaultMavenRepositoryLayoutUtils.getFormattedOutputDirectory(repositoryFile, artifact);
        if (!artifactFolderDestination.exists()) {
            artifactFolderDestination.mkdirs();
        }
        try {
            this.generateArtifactFile(artifact, artifactFolderDestination, repositoryFile);
            this.generateDependencyDescriptorFile(artifact, artifactFolderDestination, classLoaderModel);
        }
        catch (IOException e) {
            throw new IOException(String.format("There was a problem while copying the artifact [%s] file [%s] to the application local repository", artifact.toString(), artifact.getFile().getAbsolutePath()), e);
        }
    }

    protected void generateArtifactFile(Artifact artifact, File artifactFolderDestination, File repositoryFile) throws IOException {
        String artifactFilename = DefaultMavenRepositoryLayoutUtils.getFormattedFileName(artifact);
        File destinationArtifactFile = new File(artifactFolderDestination, artifactFilename);
        this.log.info((CharSequence)String.format("Adding artifact <%s%s>", "repository", destinationArtifactFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
        FileUtils.copyFile((File)artifact.getFile(), (File)destinationArtifactFile);
    }

    protected void generateDependencyDescriptorFile(Artifact artifact, File artifactFolderDestination, Optional<ClassLoaderModel> classLoaderModel) throws IOException {
        if (classLoaderModel.isPresent()) {
            this.generateClassloderModelFile(classLoaderModel.get(), artifactFolderDestination);
        } else {
            this.generatePomFile(artifact, artifactFolderDestination);
        }
    }

    protected void generatePomFile(Artifact artifact, File artifactFolderDestination) throws IOException {
        String artifactPomFilename = DefaultMavenRepositoryLayoutUtils.getPomFileName(artifact);
        File srcPomFile = new File(artifact.getFile().getParent(), artifactPomFilename);
        File destinationPomFile = new File(artifactFolderDestination, artifactPomFilename);
        if (!srcPomFile.exists()) {
            srcPomFile = new File(artifact.getFile().getParent(), POM_FILE_NAME);
        }
        FileUtils.copyFile((File)srcPomFile, (File)destinationPomFile);
    }

    protected void generateClassloderModelFile(ClassLoaderModel classLoaderModel, File artifactFolderDestination) {
        ContentGenerator.createClassLoaderModelJsonFile(classLoaderModel, artifactFolderDestination);
    }
}

