/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.repository;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.mule.tools.api.classloader.model.ApplicationClassLoaderModelAssembler;
import org.mule.tools.api.classloader.model.ApplicationClassloaderModel;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;
import org.mule.tools.api.repository.ArtifactInstaller;
import org.mule.tools.api.util.FileUtils;

public class RepositoryGenerator {
    private final ArtifactInstaller artifactInstaller;
    private final ApplicationClassLoaderModelAssembler applicationClassLoaderModelAssembler;
    protected File outputDirectory;
    private File projectPomFile;

    public RepositoryGenerator(File projectPomFile, File outputDirectory, ArtifactInstaller artifactInstaller, ApplicationClassLoaderModelAssembler applicationClassLoaderModelAssembler) {
        this.projectPomFile = projectPomFile;
        this.outputDirectory = outputDirectory;
        this.artifactInstaller = artifactInstaller;
        this.applicationClassLoaderModelAssembler = applicationClassLoaderModelAssembler;
    }

    public ClassLoaderModel generate() throws IOException, IllegalStateException {
        ApplicationClassloaderModel appModel = this.applicationClassLoaderModelAssembler.getApplicationClassLoaderModel(this.projectPomFile, this.outputDirectory);
        this.installArtifacts(this.getRepositoryFolder(), this.artifactInstaller, appModel);
        return appModel.getClassLoaderModel();
    }

    protected File getRepositoryFolder() {
        File repositoryFolder = new File(this.outputDirectory, "repository");
        if (!repositoryFolder.exists()) {
            repositoryFolder.mkdirs();
        }
        return repositoryFolder;
    }

    protected void installArtifacts(File repositoryFile, ArtifactInstaller installer, ApplicationClassloaderModel appModel) throws IOException {
        Map mulePluginsClassloaderModels = appModel.getMulePluginsClassloaderModels().stream().collect(Collectors.toMap(ClassLoaderModel::getArtifactCoordinates, Function.identity()));
        TreeSet<Artifact> sortedArtifacts = new TreeSet<Artifact>(appModel.getArtifacts());
        if (sortedArtifacts.isEmpty()) {
            this.generateMarkerFileInRepositoryFolder(repositoryFile);
        }
        for (Artifact artifact : sortedArtifacts) {
            Optional<ClassLoaderModel> mulePluginClassloaderOptional = Optional.ofNullable(mulePluginsClassloaderModels.get(ArtifactUtils.toArtifactCoordinates(artifact)));
            installer.installArtifact(repositoryFile, artifact, mulePluginClassloaderOptional);
        }
    }

    protected void generateMarkerFileInRepositoryFolder(File repositoryFile) throws IOException {
        File markerFile = new File(repositoryFile, ".marker");
        try {
            FileUtils.checkReadOnly(repositoryFile);
            markerFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOException(String.format("The current repository has no artifacts to install, and trying to create [%s] failed", markerFile.toString()), e);
        }
    }
}

