/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.maven.client.api.model.BundleDependency;

public class MulePluginDependencyResolutionValidator {
    public static void verifyThatAreNoTransitiveMulePlugins(Map<BundleDependency, List<BundleDependency>> mulePluginDependencies) throws IllegalStateException {
        Set validMulePluginsDependencies = mulePluginDependencies.keySet().stream().map(x$0 -> new BaseVersionBundleDescriptor((BundleDependency)x$0)).collect(Collectors.toSet());
        Set mulePluginsResolvedAsMulePluginsDependencies = mulePluginDependencies.values().stream().flatMap(Collection::stream).filter(bundleDependency -> bundleDependency.getDescriptor().getClassifier().isPresent()).filter(bundleDependency -> StringUtils.equals((CharSequence)"mule-plugin", (CharSequence)bundleDependency.getDescriptor().getClassifier().get())).map(x$0 -> new BaseVersionBundleDescriptor((BundleDependency)x$0)).collect(Collectors.toSet());
        mulePluginsResolvedAsMulePluginsDependencies.removeAll(validMulePluginsDependencies);
        if (!mulePluginsResolvedAsMulePluginsDependencies.isEmpty()) {
            throw new IllegalStateException("The following mule plugins are TRANSITIVE dependencies of mule plugins but not a DIRECT dependencies of a mule plugin: " + mulePluginsResolvedAsMulePluginsDependencies);
        }
    }

    private static class BaseVersionBundleDescriptor {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private BaseVersionBundleDescriptor(BundleDependency bundleDependency) {
            this.groupId = bundleDependency.getDescriptor().getGroupId();
            this.artifactId = bundleDependency.getDescriptor().getArtifactId();
            this.version = bundleDependency.getDescriptor().getBaseVersion();
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseVersionBundleDescriptor that = (BaseVersionBundleDescriptor)o;
            if (!this.getGroupId().equals(that.getGroupId())) {
                return false;
            }
            if (!this.getArtifactId().equals(that.getArtifactId())) {
                return false;
            }
            return this.getVersion().equals(that.getVersion());
        }

        public int hashCode() {
            int result = this.getGroupId().hashCode();
            result = 31 * result + this.getArtifactId().hashCode();
            result = 31 * result + this.getVersion().hashCode();
            return result;
        }
    }
}

