type MultipartPart = {
  headers?: {
    "Content-Disposition"?: {
      name: String,
      filename?: String
    },
    "Content-Type"?: String
  },
  content: String | Binary
}

type Multipart = {
  preamble?: String,
  parts: {
    _?: MultipartPart
  }
}

fun field(name: String, content: String | Binary, mime: String = "", fileName: String = ""): MultipartPart =
  {
    headers: {
      ("Content-Type": "application/json") if mime != '',
      "Content-Disposition": {
        "name": name,
        ("filename": fileName) if fileName != ''
      }
    },
    content: content
  }

fun form(parts: Array<MultipartPart>): Multipart = {
  parts: parts reduce ((val, carry = {}) -> carry ++ { (val.headers['Content-Disposition'].name): val })
}


var boundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

fun generateBoundary(len: Number = 70): String =
  using(maxChars = sizeOf(boundaryChars))
    (1 to len) map boundaryChars[floor(random() * maxChars)] joinBy ''
