/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.internal;

import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;

public class DefaultTypeResolver
implements TypeResolver {
    private final Map<String, TypeLoader> loaders;
    private final PrimitiveTypesTypeLoader primitiveTypesTypeLoader;

    public DefaultTypeResolver(Map<String, TypeLoader> loaders) {
        MetadataTypeUtils.checkArgument(MetadataTypeUtils.isNotNull(loaders), "loaders cannot be null.");
        this.loaders = loaders;
        this.primitiveTypesTypeLoader = new PrimitiveTypesTypeLoader();
    }

    @Override
    public Optional<MetadataType> resolveType(String reference) throws TypeResolverException {
        String[] elements = reference.split("::");
        String catalog = elements[0];
        String type = elements.length == 1 ? catalog : elements[1];
        return this.resolveType(catalog, type);
    }

    private Optional<MetadataType> resolveType(String catalog, String typeIdentifier) throws TypeResolverException {
        Optional<MetadataType> optionalPrimitiveType = this.primitiveTypesTypeLoader.load(catalog);
        if (optionalPrimitiveType.isPresent()) {
            return optionalPrimitiveType;
        }
        TypeLoader typeLoader = this.loaders.get(catalog);
        if (typeLoader == null) {
            throw new TypeResolverException(String.format("Catalog '%s' not found", catalog));
        }
        return typeLoader.load(typeIdentifier);
    }
}

