/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.config.spring.api.dsl.model.ResourceProvider;

public class ClassLoaderResourceProvider
implements ResourceProvider {
    private ClassLoader classLoader;

    public ClassLoaderResourceProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getResourceAsStream(String uri) {
        URL resourceUrl = this.classLoader.getResource(uri);
        if (resourceUrl == null) {
            return null;
        }
        File resourceFile = FileUtils.toFile((URL)resourceUrl);
        if (!resourceFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(resourceFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

