/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.api.dsl.ConfigurableInstanceFactory;
import org.mule.runtime.config.spring.api.dsl.ConfigurableObjectFactory;
import org.mule.runtime.config.spring.api.dsl.model.ComponentBuildingDefinitionProviderUtils;
import org.mule.runtime.config.spring.internal.CustomEncryptionStrategyDelegate;
import org.mule.runtime.config.spring.internal.CustomSecurityProviderDelegate;
import org.mule.runtime.config.spring.internal.MuleConfigurationConfigurator;
import org.mule.runtime.config.spring.internal.NotificationConfig;
import org.mule.runtime.config.spring.internal.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.spring.internal.dsl.processor.CustomSecurityFilterObjectFactory;
import org.mule.runtime.config.spring.internal.dsl.processor.EnvironmentPropertyObjectFactory;
import org.mule.runtime.config.spring.internal.dsl.processor.ReconnectionConfigObjectFactory;
import org.mule.runtime.config.spring.internal.dsl.processor.RetryPolicyTemplateObjectFactory;
import org.mule.runtime.config.spring.internal.dsl.processor.factory.MessageEnricherObjectFactory;
import org.mule.runtime.config.spring.internal.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.runtime.config.spring.internal.factories.ChoiceRouterObjectFactory;
import org.mule.runtime.config.spring.internal.factories.DefaultFlowFactoryBean;
import org.mule.runtime.config.spring.internal.factories.FlowRefFactoryBean;
import org.mule.runtime.config.spring.internal.factories.MessageProcessorFilterPairFactoryBean;
import org.mule.runtime.config.spring.internal.factories.ModuleOperationMessageProcessorChainFactoryBean;
import org.mule.runtime.config.spring.internal.factories.ResponseMessageProcessorsFactoryBean;
import org.mule.runtime.config.spring.internal.factories.SchedulingMessageSourceFactoryBean;
import org.mule.runtime.config.spring.internal.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.runtime.config.spring.internal.factories.TryProcessorFactoryBean;
import org.mule.runtime.config.spring.internal.factories.streaming.InMemoryCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.spring.internal.factories.streaming.InMemoryCursorStreamProviderObjectFactory;
import org.mule.runtime.config.spring.internal.factories.streaming.NullCursorIteratorProviderObjectFactory;
import org.mule.runtime.config.spring.internal.factories.streaming.NullCursorStreamProviderObjectFactory;
import org.mule.runtime.config.spring.privileged.dsl.processor.AddVariablePropertyConfigurator;
import org.mule.runtime.config.spring.privileged.dsl.processor.MessageProcessorChainFactoryBean;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.notification.AbstractServerNotification;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.Notification;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.AnnotatedProcessor;
import org.mule.runtime.core.api.processor.LoggerMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.MuleSecurityManagerConfigurator;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.polling.CronScheduler;
import org.mule.runtime.core.api.source.polling.FixedFrequencyScheduler;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.xa.XaTransactionFactory;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.el.ExpressionLanguageComponent;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.el.mvel.configuration.AliasEntry;
import org.mule.runtime.core.el.mvel.configuration.ImportEntry;
import org.mule.runtime.core.el.mvel.configuration.MVELExpressionLanguageObjectFactory;
import org.mule.runtime.core.el.mvel.configuration.MVELGlobalFunctionsConfig;
import org.mule.runtime.core.internal.enricher.MessageEnricher;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.OnErrorContinueHandler;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor;
import org.mule.runtime.core.internal.processor.InvokerMessageProcessor;
import org.mule.runtime.core.internal.processor.ResponseMessageProcessorAdapter;
import org.mule.runtime.core.internal.processor.TryScope;
import org.mule.runtime.core.internal.processor.simple.AddFlowVariableProcessor;
import org.mule.runtime.core.internal.processor.simple.ParseTemplateProcessor;
import org.mule.runtime.core.internal.processor.simple.RemoveFlowVariableProcessor;
import org.mule.runtime.core.internal.processor.simple.SetPayloadMessageProcessor;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.routing.ChoiceRouter;
import org.mule.runtime.core.internal.routing.FirstSuccessful;
import org.mule.runtime.core.internal.routing.Foreach;
import org.mule.runtime.core.internal.routing.IdempotentMessageValidator;
import org.mule.runtime.core.internal.routing.MessageChunkAggregator;
import org.mule.runtime.core.internal.routing.MessageChunkSplitter;
import org.mule.runtime.core.internal.routing.MessageProcessorExpressionPair;
import org.mule.runtime.core.internal.routing.Resequencer;
import org.mule.runtime.core.internal.routing.RoundRobin;
import org.mule.runtime.core.internal.routing.ScatterGatherRouter;
import org.mule.runtime.core.internal.routing.SimpleCollectionAggregator;
import org.mule.runtime.core.internal.routing.Splitter;
import org.mule.runtime.core.internal.routing.UntilSuccessful;
import org.mule.runtime.core.internal.routing.forkjoin.CollectListForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.requestreply.SimpleAsyncRequestReplyRequester;
import org.mule.runtime.core.internal.security.PasswordBasedEncryptionStrategy;
import org.mule.runtime.core.internal.security.SecretKeyEncryptionStrategy;
import org.mule.runtime.core.internal.security.UsernamePasswordAuthenticationFilter;
import org.mule.runtime.core.internal.security.filter.MuleEncryptionEndpointSecurityFilter;
import org.mule.runtime.core.internal.source.scheduler.DefaultSchedulerMessageSource;
import org.mule.runtime.core.internal.transformer.codec.XmlEntityDecoder;
import org.mule.runtime.core.internal.transformer.codec.XmlEntityEncoder;
import org.mule.runtime.core.internal.transformer.compression.GZipCompressTransformer;
import org.mule.runtime.core.internal.transformer.compression.GZipUncompressTransformer;
import org.mule.runtime.core.internal.transformer.encryption.AbstractEncryptionTransformer;
import org.mule.runtime.core.internal.transformer.encryption.DecryptionTransformer;
import org.mule.runtime.core.internal.transformer.encryption.EncryptionTransformer;
import org.mule.runtime.core.internal.transformer.expression.AbstractExpressionTransformer;
import org.mule.runtime.core.internal.transformer.expression.ExpressionArgument;
import org.mule.runtime.core.internal.transformer.expression.ExpressionTransformer;
import org.mule.runtime.core.internal.transformer.simple.AutoTransformer;
import org.mule.runtime.core.internal.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.internal.transformer.simple.HexStringToByteArray;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.mule.runtime.core.internal.transformer.simple.StringAppendTransformer;
import org.mule.runtime.core.privileged.expression.ExpressionConfig;
import org.mule.runtime.core.privileged.processor.IdempotentRedeliveryPolicy;
import org.mule.runtime.core.privileged.processor.objectfactory.MessageProcessorChainObjectFactory;
import org.mule.runtime.core.privileged.processor.simple.AbstractAddVariablePropertyProcessor;
import org.mule.runtime.core.privileged.transformer.simple.ByteArrayToObject;
import org.mule.runtime.core.privileged.transformer.simple.ByteArrayToSerializable;
import org.mule.runtime.core.privileged.transformer.simple.SerializableToByteArray;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.CommonTypeConverters;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.mule.runtime.dsl.api.component.TypeConverter;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.ExtensionConstants;

public class CoreComponentBuildingDefinitionProvider
implements ComponentBuildingDefinitionProvider {
    private static final String MESSAGE_PROCESSORS = "messageProcessors";
    private static final String NAME = "name";
    private static final String EXCEPTION_STRATEGY = "exception-strategy";
    private static final String ON_ERROR_CONTINUE = "on-error-continue";
    private static final String WHEN = "when";
    private static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    private static final String ERROR_HANDLER = "error-handler";
    private static final String SET_PAYLOAD = "set-payload";
    private static final String LOGGER = "logger";
    private static final String PROCESSOR_CHAIN = "processor-chain";
    private static final String ROUTE = "route";
    private static final String ROUTES = "routes";
    private static final String PROCESSOR = "processor";
    private static final String TRANSFORMER = "transformer";
    private static final String CUSTOM_PROCESSOR = "custom-processor";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String SUB_FLOW = "sub-flow";
    private static final String RESPONSE = "response";
    private static final String FLOW = "flow";
    private static final String FLOW_REF = "flow-ref";
    private static final String EXCEPTION_LISTENER_ATTRIBUTE = "exceptionListener";
    private static final String SCATTER_GATHER = "scatter-gather";
    private static final String FORK_JOIN_STRATEGY = "forkJoinStrategyFactory";
    private static final String COLLECT_LIST = "collect-list";
    private static final String ENRICHER = "enricher";
    private static final String ASYNC = "async";
    private static final String TRY = "try";
    private static final String UNTIL_SUCCESSFUL = "until-successful";
    private static final String FOREACH = "foreach";
    private static final String FIRST_SUCCESSFUL = "first-successful";
    private static final String ROUND_ROBIN = "round-robin";
    private static final String CHOICE = "choice";
    private static final String OTHERWISE = "otherwise";
    private static final String SCHEDULER = "scheduler";
    private static final String REQUEST_REPLY = "request-reply";
    private static final String ERROR_TYPE = "errorType";
    private static final String TYPE = "type";
    private static final String TX_ACTION = "transactionalAction";
    private static final String TX_TYPE = "transactionType";
    private static final Class<?> MESSAGE_PROCESSOR_CLASS = Processor.class;
    private static ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withNamespace("mule");
    private ComponentBuildingDefinition.Builder transactionManagerBaseDefinition;

    @Override
    public void init() {
        this.transactionManagerBaseDefinition = baseDefinition;
    }

    @Override
    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions = new LinkedList<ComponentBuildingDefinition>();
        AttributeDefinition messageProcessorListAttributeDefinition = AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build();
        ComponentBuildingDefinition.Builder exceptionStrategyBaseBuilder = baseDefinition.withSetterParameterDefinition(MESSAGE_PROCESSORS, messageProcessorListAttributeDefinition).withSetterParameterDefinition("globalName", AttributeDefinition.Builder.fromSimpleParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(EXCEPTION_STRATEGY).withTypeDefinition(TypeDefinition.fromType(Object.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("ref").build()).build());
        componentBuildingDefinitions.add(exceptionStrategyBaseBuilder.withIdentifier(ON_ERROR_CONTINUE).withTypeDefinition(TypeDefinition.fromType(OnErrorContinueHandler.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(WHEN, AttributeDefinition.Builder.fromSimpleParameter(WHEN).build()).withSetterParameterDefinition(ERROR_TYPE, AttributeDefinition.Builder.fromSimpleParameter(TYPE).build()).asPrototype().build());
        componentBuildingDefinitions.add(exceptionStrategyBaseBuilder.withIdentifier(ON_ERROR_PROPAGATE).withTypeDefinition(TypeDefinition.fromType(OnErrorPropagateHandler.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(WHEN, AttributeDefinition.Builder.fromSimpleParameter(WHEN).build()).withSetterParameterDefinition(ERROR_TYPE, AttributeDefinition.Builder.fromSimpleParameter(TYPE).build()).withSetterParameterDefinition("maxRedeliveryAttempts", AttributeDefinition.Builder.fromSimpleParameter("maxRedeliveryAttempts").build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ERROR_HANDLER).withTypeDefinition(TypeDefinition.fromType(ErrorHandler.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("exceptionListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessagingExceptionHandler.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SET_PAYLOAD).withTypeDefinition(TypeDefinition.fromType(SetPayloadMessageProcessor.class)).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter("value").build()).withSetterParameterDefinition("mimeType", AttributeDefinition.Builder.fromSimpleParameter("mimeType").build()).withSetterParameterDefinition("encoding", AttributeDefinition.Builder.fromSimpleParameter("encoding").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(LOGGER).withTypeDefinition(TypeDefinition.fromType(LoggerMessageProcessor.class)).withSetterParameterDefinition("message", AttributeDefinition.Builder.fromSimpleParameter("message").build()).withSetterParameterDefinition("category", AttributeDefinition.Builder.fromSimpleParameter("category").build()).withSetterParameterDefinition("level", AttributeDefinition.Builder.fromSimpleParameter("level").build()).build());
        componentBuildingDefinitions.add(CoreComponentBuildingDefinitionProvider.getSetVariablePropertyBaseBuilder(this.getAddVariableTransformerInstanceFactory(AddFlowVariableProcessor.class), AddFlowVariableProcessor.class, KeyAttributeDefinitionPair.newBuilder().withKey("identifier").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("variableName").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("value").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("value").build()).build()).withIdentifier("set-variable").withTypeDefinition(TypeDefinition.fromType(AddFlowVariableProcessor.class)).build());
        componentBuildingDefinitions.add(this.getCoreMuleMessageTransformerBaseBuilder().withIdentifier("remove-variable").withTypeDefinition(TypeDefinition.fromType(RemoveFlowVariableProcessor.class)).withSetterParameterDefinition("identifier", AttributeDefinition.Builder.fromSimpleParameter("variableName").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("global-property").withTypeDefinition(TypeDefinition.fromType(String.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("value").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(TRANSFORMER).withTypeDefinition(TypeDefinition.fromType(Transformer.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(CUSTOM_PROCESSOR).withTypeDefinition(TypeDefinition.fromConfigurationAttribute(CLASS_ATTRIBUTE).checkingThatIsClassOrInheritsFrom(MESSAGE_PROCESSOR_CLASS)).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(PROCESSOR_CHAIN).withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(MessageProcessorChainObjectFactory.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ROUTE).withTypeDefinition(TypeDefinition.fromType(MessageProcessorChain.class)).withObjectFactoryType(MessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        this.addModuleOperationChainParser(componentBuildingDefinitions);
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SUB_FLOW).withTypeDefinition(TypeDefinition.fromType(MessageProcessorChain.class)).withObjectFactoryType(SubflowMessageProcessorChainFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(RESPONSE).withTypeDefinition(TypeDefinition.fromType(ResponseMessageProcessorAdapter.class)).withObjectFactoryType(ResponseMessageProcessorsFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FLOW).withTypeDefinition(TypeDefinition.fromType(Flow.class)).withObjectFactoryType(DefaultFlowFactoryBean.class).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition("initialState", AttributeDefinition.Builder.fromSimpleParameter("initialState").withDefaultValue("started").build()).withSetterParameterDefinition("messageSource", AttributeDefinition.Builder.fromChildConfiguration(MessageSource.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(MessagingExceptionHandler.class).build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter("maxConcurrency").build()).build());
        ComponentBuildingDefinition.Builder<AnnotatedProcessor> processorRefBuilder = baseDefinition.withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(FlowRefFactoryBean.class);
        componentBuildingDefinitions.add(processorRefBuilder.withIdentifier(FLOW_REF).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).build());
        componentBuildingDefinitions.add(processorRefBuilder.withIdentifier(PROCESSOR).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter("ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(COLLECT_LIST).withTypeDefinition(TypeDefinition.fromType(CollectListForkJoinStrategyFactory.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SCATTER_GATHER).withTypeDefinition(TypeDefinition.fromType(ScatterGatherRouter.class)).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter("timeout").build()).withSetterParameterDefinition("maxConcurrency", AttributeDefinition.Builder.fromSimpleParameter("maxConcurrency").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter("target").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter("targetValue").withDefaultValue("#[payload]").build()).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).withSetterParameterDefinition(FORK_JOIN_STRATEGY, AttributeDefinition.Builder.fromChildConfiguration(ForkJoinStrategyFactory.class).build()).asScope().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ENRICHER).withObjectFactoryType(MessageEnricherObjectFactory.class).withTypeDefinition(TypeDefinition.fromType(MessageEnricher.class)).withSetterParameterDefinition("messageProcessor", AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).withSetterParameterDefinition("enrichExpressionPairs", AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageEnricher.EnrichExpressionPair.class).build()).withSetterParameterDefinition("source", AttributeDefinition.Builder.fromSimpleParameter("source").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter("target").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("enrich").withTypeDefinition(TypeDefinition.fromType(MessageEnricher.EnrichExpressionPair.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("source").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("target").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ASYNC).withTypeDefinition(TypeDefinition.fromType(AsyncDelegateMessageProcessor.class)).withObjectFactoryType(AsyncMessageProcessorsFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(TRY).withTypeDefinition(TypeDefinition.fromType(TryScope.class)).withObjectFactoryType(TryProcessorFactoryBean.class).withSetterParameterDefinition(EXCEPTION_LISTENER_ATTRIBUTE, AttributeDefinition.Builder.fromChildConfiguration(MessagingExceptionHandler.class).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition(TX_ACTION, AttributeDefinition.Builder.fromSimpleParameter(TX_ACTION).withDefaultValue("INDIFFERENT").build()).withSetterParameterDefinition(TX_TYPE, AttributeDefinition.Builder.fromSimpleParameter(TX_TYPE, this.getTransactionTypeConverter()).withDefaultValue(TransactionType.LOCAL.name()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(UNTIL_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(UntilSuccessful.class)).withSetterParameterDefinition("maxRetries", AttributeDefinition.Builder.fromSimpleParameter("maxRetries").withDefaultValue(5).build()).withSetterParameterDefinition("millisBetweenRetries", AttributeDefinition.Builder.fromSimpleParameter("millisBetweenRetries").withDefaultValue(60000).build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FOREACH).withTypeDefinition(TypeDefinition.fromType(Foreach.class)).withSetterParameterDefinition("collectionExpression", AttributeDefinition.Builder.fromSimpleParameter("collection").build()).withSetterParameterDefinition("batchSize", AttributeDefinition.Builder.fromSimpleParameter("batchSize").build()).withSetterParameterDefinition("rootMessageVariableName", AttributeDefinition.Builder.fromSimpleParameter("rootMessageVariableName").build()).withSetterParameterDefinition("counterVariableName", AttributeDefinition.Builder.fromSimpleParameter("counterVariableName").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(FIRST_SUCCESSFUL).withTypeDefinition(TypeDefinition.fromType(FirstSuccessful.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(ROUND_ROBIN).withTypeDefinition(TypeDefinition.fromType(RoundRobin.class)).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorChain.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(CHOICE).withTypeDefinition(TypeDefinition.fromType(ChoiceRouter.class)).withObjectFactoryType(ChoiceRouterObjectFactory.class).withSetterParameterDefinition(ROUTES, AttributeDefinition.Builder.fromChildCollectionConfiguration(MessageProcessorExpressionPair.class).build()).withSetterParameterDefinition("defaultRoute", AttributeDefinition.Builder.fromChildConfiguration(MessageProcessorExpressionPair.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(WHEN).withTypeDefinition(TypeDefinition.fromType(MessageProcessorExpressionPair.class)).withObjectFactoryType(MessageProcessorFilterPairFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter("expression").withDefaultValue("true").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(OTHERWISE).withTypeDefinition(TypeDefinition.fromType(MessageProcessorExpressionPair.class)).withObjectFactoryType(MessageProcessorFilterPairFactoryBean.class).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromFixedValue("true").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("message-chunk-splitter").withTypeDefinition(TypeDefinition.fromType(MessageChunkSplitter.class)).withSetterParameterDefinition("messageSize", AttributeDefinition.Builder.fromSimpleParameter("messageSize").build()).build());
        ComponentBuildingDefinition.Builder baseAggregatorDefinition = baseDefinition.withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter("timeout").build()).withSetterParameterDefinition("failOnTimeout", AttributeDefinition.Builder.fromSimpleParameter("failOnTimeout").build()).withSetterParameterDefinition("processedGroupsObjectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter("processed-groups-object-store").build()).withSetterParameterDefinition("eventGroupsObjectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter("event-groups-object-store").build()).withSetterParameterDefinition("persistentStores", AttributeDefinition.Builder.fromSimpleParameter("persistentStores").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter("storePrefix").build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.withIdentifier("message-chunk-aggregator").withTypeDefinition(TypeDefinition.fromType(MessageChunkAggregator.class)).build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.withIdentifier("collection-aggregator").withTypeDefinition(TypeDefinition.fromType(SimpleCollectionAggregator.class)).build());
        componentBuildingDefinitions.add(baseAggregatorDefinition.withIdentifier("resequencer").withTypeDefinition(TypeDefinition.fromType(Resequencer.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("splitter").withTypeDefinition(TypeDefinition.fromType(Splitter.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter("expression").build()).withSetterParameterDefinition("filterOnErrorType", AttributeDefinition.Builder.fromSimpleParameter("filterOnErrorType").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(REQUEST_REPLY).withTypeDefinition(TypeDefinition.fromType(SimpleAsyncRequestReplyRequester.class)).withSetterParameterDefinition("messageProcessor", AttributeDefinition.Builder.fromChildConfiguration(Processor.class).build()).withSetterParameterDefinition("messageSource", AttributeDefinition.Builder.fromChildConfiguration(MessageSource.class).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter("timeout").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter("storePrefix").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier(SCHEDULER).withTypeDefinition(TypeDefinition.fromType(DefaultSchedulerMessageSource.class)).withObjectFactoryType(SchedulingMessageSourceFactoryBean.class).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter("frequency").build()).withSetterParameterDefinition(SCHEDULER, AttributeDefinition.Builder.fromChildConfiguration(PeriodicScheduler.class).withWrapperIdentifier("scheduling-strategy").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("fixed-frequency").withTypeDefinition(TypeDefinition.fromType(FixedFrequencyScheduler.class)).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter("frequency").build()).withSetterParameterDefinition("startDelay", AttributeDefinition.Builder.fromSimpleParameter("startDelay").build()).withSetterParameterDefinition("timeUnit", AttributeDefinition.Builder.fromSimpleParameter("timeUnit").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("cron").withTypeDefinition(TypeDefinition.fromType(CronScheduler.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromSimpleParameter("expression").build()).withSetterParameterDefinition("timeZone", AttributeDefinition.Builder.fromSimpleParameter("timeZone").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("redelivery-policy").withTypeDefinition(TypeDefinition.fromType(IdempotentRedeliveryPolicy.class)).withSetterParameterDefinition("useSecureHash", AttributeDefinition.Builder.fromSimpleParameter("useSecureHash").build()).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter("messageDigestAlgorithm").build()).withSetterParameterDefinition("maxRedeliveryCount", AttributeDefinition.Builder.fromSimpleParameter("maxRedeliveryCount").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter("idExpression").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter("idExpression").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter("object-store-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("configuration").withTypeDefinition(TypeDefinition.fromType(MuleConfiguration.class)).withObjectFactoryType(MuleConfigurationConfigurator.class).withSetterParameterDefinition("defaultErrorHandlerName", AttributeDefinition.Builder.fromSimpleParameter("defaultErrorHandler-ref").build()).withSetterParameterDefinition("defaultResponseTimeout", AttributeDefinition.Builder.fromSimpleParameter("defaultResponseTimeout").build()).withSetterParameterDefinition("maxQueueTransactionFilesSize", AttributeDefinition.Builder.fromSimpleParameter("maxQueueTransactionFilesSize").build()).withSetterParameterDefinition("defaultTransactionTimeout", AttributeDefinition.Builder.fromSimpleParameter("defaultTransactionTimeout").build()).withSetterParameterDefinition("shutdownTimeout", AttributeDefinition.Builder.fromSimpleParameter("shutdownTimeout").build()).withSetterParameterDefinition("defaultTransactionTimeout", AttributeDefinition.Builder.fromSimpleParameter("defaultTransactionTimeout").build()).withSetterParameterDefinition("useExtendedTransformations", AttributeDefinition.Builder.fromSimpleParameter("useExtendedTransformations").build()).withSetterParameterDefinition("flowEndingWithOneWayEndpointReturnsNull", AttributeDefinition.Builder.fromSimpleParameter("flowEndingWithOneWayEndpointReturnsNull").build()).withSetterParameterDefinition("enricherPropagatesSessionVariableChanges", AttributeDefinition.Builder.fromSimpleParameter("enricherPropagatesSessionVariableChanges").build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(Object.class).build()).withSetterParameterDefinition("defaultObjectSerializer", AttributeDefinition.Builder.fromSimpleReferenceParameter("defaultObjectSerializer-ref").build()).withSetterParameterDefinition("extensions", AttributeDefinition.Builder.fromChildCollectionConfiguration(ConfigurationExtension.class).build()).withSetterParameterDefinition("expressionLanguage", AttributeDefinition.Builder.fromChildConfiguration(MVELExpressionLanguage.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("notifications").withTypeDefinition(TypeDefinition.fromType(ServerNotificationManagerConfigurator.class)).withSetterParameterDefinition("notificationDynamic", AttributeDefinition.Builder.fromSimpleParameter("dynamic").build()).withSetterParameterDefinition("enabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.EnabledNotificationConfig.class).build()).withSetterParameterDefinition("disabledNotifications", AttributeDefinition.Builder.fromChildCollectionConfiguration(NotificationConfig.DisabledNotificationConfig.class).build()).withSetterParameterDefinition("notificationListeners", AttributeDefinition.Builder.fromChildCollectionConfiguration(ListenerSubscriptionPair.class).build()).build());
        ComponentBuildingDefinition.Builder<NotificationConfig> baseNotificationDefinition = baseDefinition.withSetterParameterDefinition("interfaceName", AttributeDefinition.Builder.fromSimpleParameter("interface").build()).withSetterParameterDefinition("eventName", AttributeDefinition.Builder.fromSimpleParameter("event").build()).withSetterParameterDefinition("interfaceClass", AttributeDefinition.Builder.fromSimpleParameter("interface-class").build()).withSetterParameterDefinition("eventClass", AttributeDefinition.Builder.fromSimpleParameter("event-class").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.withTypeDefinition(TypeDefinition.fromType(NotificationConfig.EnabledNotificationConfig.class)).withIdentifier("notification").build());
        componentBuildingDefinitions.add(baseNotificationDefinition.withTypeDefinition(TypeDefinition.fromType(NotificationConfig.DisabledNotificationConfig.class)).withIdentifier("disable-notification").build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("notification-listener").withTypeDefinition(TypeDefinition.fromType(ListenerSubscriptionPair.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("subscription", this.getNotificationSubscriptionConverter()).withDefaultValue("*").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("username-password-filter").withTypeDefinition(TypeDefinition.fromType(UsernamePasswordAuthenticationFilter.class)).withSetterParameterDefinition("username", AttributeDefinition.Builder.fromSimpleParameter("username").build()).withSetterParameterDefinition("password", AttributeDefinition.Builder.fromSimpleParameter("password").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-security-filter").withTypeDefinition(TypeDefinition.fromType(Processor.class)).withObjectFactoryType(CustomSecurityFilterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("encryption-security-filter").withTypeDefinition(TypeDefinition.fromType(MuleEncryptionEndpointSecurityFilter.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("strategy-ref").build()).withIgnoredConfigurationParameter(NAME).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("security-manager").withTypeDefinition(TypeDefinition.fromType(SecurityManager.class)).withObjectFactoryType(MuleSecurityManagerConfigurator.class).withSetterParameterDefinition("muleContext", AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("providers", AttributeDefinition.Builder.fromChildCollectionConfiguration(SecurityProvider.class).build()).withSetterParameterDefinition("encryptionStrategies", AttributeDefinition.Builder.fromChildCollectionConfiguration(EncryptionStrategy.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-security-provider").withTypeDefinition(TypeDefinition.fromType(CustomSecurityProviderDelegate.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("provider-ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("custom-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(CustomEncryptionStrategyDelegate.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("strategy-ref").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("secret-key-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(SecretKeyEncryptionStrategy.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter("key").build()).withSetterParameterDefinition("keyFactory", AttributeDefinition.Builder.fromSimpleReferenceParameter("keyFactory-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("password-encryption-strategy").withTypeDefinition(TypeDefinition.fromType(PasswordBasedEncryptionStrategy.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("iterationCount", AttributeDefinition.Builder.fromSimpleParameter("iterationCount").build()).withSetterParameterDefinition("password", AttributeDefinition.Builder.fromSimpleParameter("password").build()).withSetterParameterDefinition("salt", AttributeDefinition.Builder.fromSimpleParameter("salt").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("redelivery-policy").withTypeDefinition(TypeDefinition.fromType(IdempotentRedeliveryPolicy.class)).withSetterParameterDefinition("maxRedeliveryCount", AttributeDefinition.Builder.fromSimpleParameter("maxRedeliveryCount").build()).withSetterParameterDefinition("useSecureHash", AttributeDefinition.Builder.fromSimpleParameter("useSecureHash").build()).withSetterParameterDefinition("messageDigestAlgorithm", AttributeDefinition.Builder.fromSimpleParameter("messageDigestAlgorithm").build()).withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter("idExpression").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter("object-store-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("pooling-profile").withTypeDefinition(TypeDefinition.fromType(PoolingProfile.class)).withSetterParameterDefinition("maxActive", AttributeDefinition.Builder.fromSimpleParameter("maxActive").build()).withSetterParameterDefinition("maxIdle", AttributeDefinition.Builder.fromSimpleParameter("maxIdle").build()).withSetterParameterDefinition("exhaustedAction", AttributeDefinition.Builder.fromSimpleParameter("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS::get).build()).withSetterParameterDefinition("maxWait", AttributeDefinition.Builder.fromSimpleParameter("maxWait").build()).withSetterParameterDefinition("evictionCheckIntervalMillis", AttributeDefinition.Builder.fromSimpleParameter("evictionCheckIntervalMillis").build()).withSetterParameterDefinition("minEvictionMillis", AttributeDefinition.Builder.fromSimpleParameter("minEvictionMillis").build()).withSetterParameterDefinition("disabled", AttributeDefinition.Builder.fromSimpleParameter("disabled").build()).withSetterParameterDefinition("initialisationPolicy", AttributeDefinition.Builder.fromSimpleParameter("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES::get).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("expression-component").withTypeDefinition(TypeDefinition.fromType(ExpressionLanguageComponent.class)).withSetterParameterDefinition("expression", AttributeDefinition.Builder.fromTextContent().build()).withSetterParameterDefinition("expressionFile", AttributeDefinition.Builder.fromSimpleParameter("file").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("invoke").withTypeDefinition(TypeDefinition.fromType(InvokerMessageProcessor.class)).withSetterParameterDefinition(NAME, AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("methodName", AttributeDefinition.Builder.fromSimpleParameter("method").build()).withSetterParameterDefinition("argumentExpressionsString", AttributeDefinition.Builder.fromSimpleParameter("methodArguments").build()).withSetterParameterDefinition("object", AttributeDefinition.Builder.fromSimpleReferenceParameter("object-ref").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("expression-language").withTypeDefinition(TypeDefinition.fromType(MVELExpressionLanguage.class)).withObjectFactoryType(MVELExpressionLanguageObjectFactory.class).withSetterParameterDefinition("autoResolveVariables", AttributeDefinition.Builder.fromSimpleParameter("autoResolveVariables").build()).withSetterParameterDefinition("globalFunctions", AttributeDefinition.Builder.fromChildConfiguration(MVELGlobalFunctionsConfig.class).build()).withSetterParameterDefinition("imports", AttributeDefinition.Builder.fromChildCollectionConfiguration(ImportEntry.class).build()).withSetterParameterDefinition("aliases", AttributeDefinition.Builder.fromChildCollectionConfiguration(AliasEntry.class).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("import").withTypeDefinition(TypeDefinition.fromType(ImportEntry.class)).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter(CLASS_ATTRIBUTE, CommonTypeConverters.stringToClassConverter()).build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("alias").withTypeDefinition(TypeDefinition.fromType(AliasEntry.class)).withSetterParameterDefinition("key", AttributeDefinition.Builder.fromSimpleParameter(NAME).build()).withSetterParameterDefinition("value", AttributeDefinition.Builder.fromSimpleParameter("expression").build()).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("global-functions").withTypeDefinition(TypeDefinition.fromType(MVELGlobalFunctionsConfig.class)).withSetterParameterDefinition("file", AttributeDefinition.Builder.fromSimpleParameter("file").build()).withSetterParameterDefinition("inlineScript", AttributeDefinition.Builder.fromTextContent().build()).build());
        componentBuildingDefinitions.addAll(this.getTransformersBuildingDefinitions());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("pooling-profile").withTypeDefinition(TypeDefinition.fromType(PoolingProfile.class)).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("maxActive").withDefaultValue(5).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("maxIdle").withDefaultValue(5).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("maxWait", value -> Long.valueOf((String)value)).withDefaultValue(String.valueOf(4000L)).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("exhaustedAction", PoolingProfile.POOL_EXHAUSTED_ACTIONS::get).withDefaultValue(String.valueOf(2)).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("initialisationPolicy", PoolingProfile.POOL_INITIALISATION_POLICIES::get).withDefaultValue(String.valueOf(1)).build()).withSetterParameterDefinition("disabled", AttributeDefinition.Builder.fromSimpleParameter("disabled").build()).build());
        componentBuildingDefinitions.addAll(this.getStreamingDefinitions());
        componentBuildingDefinitions.addAll(this.getIdempotentValidatorsDefinitions());
        componentBuildingDefinitions.addAll(this.getReconnectionDefinitions());
        componentBuildingDefinitions.addAll(this.getTransactionDefinitions());
        return componentBuildingDefinitions;
    }

    private TypeConverter<String, TransactionType> getTransactionTypeConverter() {
        return TransactionType::valueOf;
    }

    private TypeConverter<String, Predicate<? extends Notification>> getNotificationSubscriptionConverter() {
        return subscription -> {
            if ("*".equals(subscription)) {
                return n -> true;
            }
            return notification -> subscription != null ? subscription.equals(((AbstractServerNotification)notification).getResourceIdentifier()) : true;
        };
    }

    private List<ComponentBuildingDefinition> getIdempotentValidatorsDefinitions() {
        LinkedList<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder baseIdempotentMessageFilterDefinition = baseDefinition.withSetterParameterDefinition("idExpression", AttributeDefinition.Builder.fromSimpleParameter("idExpression").build()).withSetterParameterDefinition("valueExpression", AttributeDefinition.Builder.fromSimpleParameter("valueExpression").build()).withSetterParameterDefinition("storePrefix", AttributeDefinition.Builder.fromSimpleParameter("storePrefix").build()).withSetterParameterDefinition("throwOnUnaccepted", AttributeDefinition.Builder.fromSimpleParameter("throwOnUnaccepted").build()).withSetterParameterDefinition("objectStore", AttributeDefinition.Builder.fromSimpleReferenceParameter("objectStore").build()).withSetterParameterDefinition("unacceptedMessageProcessor", AttributeDefinition.Builder.fromSimpleReferenceParameter("onUnaccepted").build());
        definitions.add(baseIdempotentMessageFilterDefinition.withIdentifier("idempotent-message-validator").withTypeDefinition(TypeDefinition.fromType(IdempotentMessageValidator.class)).build());
        return definitions;
    }

    private List<ComponentBuildingDefinition> getTransformersBuildingDefinitions() {
        ArrayList<ComponentBuildingDefinition> transformerComponentBuildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(XmlEntityEncoder.class).withIdentifier("xml-entity-encoder-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(XmlEntityDecoder.class).withIdentifier("xml-entity-decoder-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(GZipCompressTransformer.class).withIdentifier("gzip-compress-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(GZipUncompressTransformer.class).withIdentifier("gzip-uncompress-transformer").build());
        KeyAttributeDefinitionPair strategyParameterDefinition = KeyAttributeDefinitionPair.newBuilder().withKey("strategy").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("strategy-ref").build()).build();
        transformerComponentBuildingDefinitions.add(ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(this.getEncryptionTransformerConfigurationFactory(EncryptionTransformer.class), EncryptionTransformer.class, strategyParameterDefinition).withIdentifier("encrypt-transformer").withNamespace("mule").build());
        transformerComponentBuildingDefinitions.add(ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(this.getEncryptionTransformerConfigurationFactory(DecryptionTransformer.class), DecryptionTransformer.class, strategyParameterDefinition).withIdentifier("decrypt-transformer").withNamespace("mule").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ByteArrayToHexString.class).withIdentifier("byte-array-to-hex-string-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(HexStringToByteArray.class).withIdentifier("hex-string-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ByteArrayToObject.class).withIdentifier("byte-array-to-object-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToByteArray.class).withIdentifier("object-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToString.class).withIdentifier("object-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ByteArrayToSerializable.class).withIdentifier("byte-array-to-serializable-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(SerializableToByteArray.class).withIdentifier("serializable-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToString.class).withIdentifier("byte-array-to-string-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(ObjectToByteArray.class).withIdentifier("string-to-byte-array-transformer").build());
        transformerComponentBuildingDefinitions.add(baseDefinition.withIdentifier("parse-template").withTypeDefinition(TypeDefinition.fromType(ParseTemplateProcessor.class)).withSetterParameterDefinition("content", AttributeDefinition.Builder.fromChildConfiguration(String.class).withIdentifier("content").build()).withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter("target").build()).withSetterParameterDefinition("location", AttributeDefinition.Builder.fromSimpleParameter("location").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter("targetValue").build()).build());
        transformerComponentBuildingDefinitions.add(this.getCoreMuleMessageTransformerBaseBuilder().withIdentifier("content").withTypeDefinition(TypeDefinition.fromType(String.class)).build());
        transformerComponentBuildingDefinitions.add(this.getCoreTransformerBaseBuilder(AutoTransformer.class).withIdentifier("auto-transformer").build());
        transformerComponentBuildingDefinitions.add(this.getCoreMuleMessageTransformerBaseBuilder().withIdentifier("append-string-transformer").withTypeDefinition(TypeDefinition.fromType(StringAppendTransformer.class)).withSetterParameterDefinition("message", AttributeDefinition.Builder.fromSimpleParameter("message").build()).build());
        transformerComponentBuildingDefinitions.add(ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(this.getCustomTransformerConfigurationFactory(), Transformer.class, KeyAttributeDefinitionPair.newBuilder().withKey(CLASS_ATTRIBUTE).withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter(CLASS_ATTRIBUTE).build()).build()).withTypeDefinition(TypeDefinition.fromConfigurationAttribute(CLASS_ATTRIBUTE)).withIdentifier("custom-transformer").withNamespace("mule").build());
        transformerComponentBuildingDefinitions.add(ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(this.getExpressionTransformerConfigurationFactory(), ExpressionTransformer.class, KeyAttributeDefinitionPair.newBuilder().withKey("returnSourceIfNull").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("returnSourceIfNull").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("arguments").withAttributeDefinition(AttributeDefinition.Builder.fromChildCollectionConfiguration(ExpressionArgument.class).build()).build()).withIdentifier("expression-transformer").withNamespace("mule").withTypeDefinition(TypeDefinition.fromType(ExpressionTransformer.class)).build());
        transformerComponentBuildingDefinitions.add(baseDefinition.withObjectFactoryType(ConfigurableObjectFactory.class).withIdentifier("return-argument").withTypeDefinition(TypeDefinition.fromType(ExpressionArgument.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue(this.getExpressionArgumentConfigurationFactory()).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions(KeyAttributeDefinitionPair.newBuilder().withKey("optional").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("optional").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()).build()).build());
        transformerComponentBuildingDefinitions.add(baseDefinition.withObjectFactoryType(ConfigurableObjectFactory.class).withIdentifier("bean-property").withTypeDefinition(TypeDefinition.fromType(ExpressionArgument.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue(this.getExpressionArgumentConfigurationFactory()).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions(KeyAttributeDefinitionPair.newBuilder().withKey("optional").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("optional").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("expression").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("expression").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("propertyName").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("property-name").build()).build()).build()).build());
        return transformerComponentBuildingDefinitions;
    }

    private ConfigurableInstanceFactory getAddVariableTransformerInstanceFactory(Class<? extends AbstractAddVariablePropertyProcessor> transformerType) {
        return parameters -> {
            AbstractAddVariablePropertyProcessor transformer = (AbstractAddVariablePropertyProcessor)ComponentBuildingDefinitionProviderUtils.createNewInstance(transformerType);
            transformer.setIdentifier((String)parameters.get("identifier"));
            transformer.setValue((String)parameters.get("value"));
            return transformer;
        };
    }

    private ConfigurableInstanceFactory getEncryptionTransformerConfigurationFactory(Class<? extends AbstractEncryptionTransformer> abstractEncryptionTransformerType) {
        return parameters -> {
            AbstractEncryptionTransformer encryptionTransformer = (AbstractEncryptionTransformer)ComponentBuildingDefinitionProviderUtils.createNewInstance(abstractEncryptionTransformerType);
            encryptionTransformer.setStrategy((EncryptionStrategy)parameters.get("strategy"));
            return encryptionTransformer;
        };
    }

    private ConfigurableInstanceFactory getCustomTransformerConfigurationFactory() {
        return parameters -> {
            String className = (String)parameters.get(CLASS_ATTRIBUTE);
            Preconditions.checkState(className != null, "custom-transformer class attribute cannot be null");
            return ComponentBuildingDefinitionProviderUtils.createNewInstance(className);
        };
    }

    private ConfigurableInstanceFactory getExpressionArgumentConfigurationFactory() {
        return parameters -> {
            String name = (String)parameters.get("propertyName");
            ExpressionArgument expressionArgument = new ExpressionArgument(name, new ExpressionConfig((String)parameters.get("expression")), Boolean.parseBoolean(Optional.ofNullable(parameters.get("optional")).orElse("false")));
            expressionArgument.setMuleContext((MuleContext)parameters.get("muleContext"));
            return expressionArgument;
        };
    }

    private ConfigurableInstanceFactory getExpressionTransformerConfigurationFactory() {
        return this.getAbstractTransformerConfigurationFactory(parameters -> {
            ExpressionTransformer expressionTransformer = new ExpressionTransformer();
            Boolean returnSourceIfNull = (Boolean)parameters.get("returnSourceIfNull");
            if (returnSourceIfNull != null) {
                expressionTransformer.setReturnSourceIfNull(returnSourceIfNull);
            }
            return expressionTransformer;
        });
    }

    private ConfigurableInstanceFactory getAbstractTransformerConfigurationFactory(Function<Map<String, Object>, AbstractExpressionTransformer> abstractExpressionTransformerFactory) {
        return parameters -> {
            List<ExpressionArgument> arguments = (List<ExpressionArgument>)parameters.get("arguments");
            String expression = (String)parameters.get("expression");
            AbstractExpressionTransformer abstractExpressionTransformer = (AbstractExpressionTransformer)abstractExpressionTransformerFactory.apply(parameters);
            if (expression != null && arguments != null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Expression transformer do not support expression attribute or return-data child element at the same time."));
            }
            if (expression != null) {
                arguments = Arrays.asList(new ExpressionArgument("single", new ExpressionConfig(expression), false));
            }
            abstractExpressionTransformer.setArguments(arguments);
            return abstractExpressionTransformer;
        };
    }

    private static ComponentBuildingDefinition.Builder getSetVariablePropertyBaseBuilder(ConfigurableInstanceFactory configurableInstanceFactory, Class<? extends AbstractAddVariablePropertyProcessor> setterClass, KeyAttributeDefinitionPair ... configurationAttributes) {
        Object[] commonTransformerParameters = new KeyAttributeDefinitionPair[]{KeyAttributeDefinitionPair.newBuilder().withKey("encoding").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("encoding").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("mimeType").withAttributeDefinition(AttributeDefinition.Builder.fromSimpleParameter("mimeType").build()).build(), KeyAttributeDefinitionPair.newBuilder().withKey("muleContext").withAttributeDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).build()};
        return baseDefinition.withTypeDefinition(TypeDefinition.fromType(setterClass)).withObjectFactoryType(new ConfigurableObjectFactory().getClass()).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue(configurableInstanceFactory).build()).withSetterParameterDefinition("commonConfiguratorType", AttributeDefinition.Builder.fromFixedValue(AddVariablePropertyConfigurator.class).build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromMultipleDefinitions((KeyAttributeDefinitionPair[])ArrayUtils.addAll((Object[])commonTransformerParameters, (Object[])configurationAttributes)).build()).asPrototype();
    }

    private List<ComponentBuildingDefinition> getStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.addAll(this.getBytesStreamingDefinitions());
        buildingDefinitions.addAll(this.getObjectsStreamingDefinitions());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getBytesStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("repeatable-in-memory-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(InMemoryCursorStreamProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("initialBufferSize").withDefaultValue(512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("bufferSizeIncrement").withDefaultValue(512).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("maxBufferSize").withDefaultValue(1024).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("bufferUnit", value -> DataUnit.valueOf((String)value)).withDefaultValue((Object)ExtensionConstants.DEFAULT_BYTE_STREAMING_BUFFER_DATA_UNIT).build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("non-repeatable-stream").withTypeDefinition(TypeDefinition.fromType(CursorStreamProviderFactory.class)).withObjectFactoryType(NullCursorStreamProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getObjectsStreamingDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("repeatable-in-memory-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(InMemoryCursorIteratorProviderObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("initialBufferSize").withDefaultValue(100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("bufferSizeIncrement").withDefaultValue(100).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("maxBufferSize").withDefaultValue(500).build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("non-repeatable-iterable").withTypeDefinition(TypeDefinition.fromType(CursorIteratorProviderFactory.class)).withObjectFactoryType(NullCursorIteratorProviderObjectFactory.class).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getReconnectionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        ComponentBuildingDefinition.Builder<RetryPolicyTemplate> baseReconnectDefinition = baseDefinition.withTypeDefinition(TypeDefinition.fromType(RetryPolicyTemplate.class)).withObjectFactoryType(RetryPolicyTemplateObjectFactory.class).withSetterParameterDefinition("blocking", AttributeDefinition.Builder.fromSimpleParameter("blocking").build()).withSetterParameterDefinition("frequency", AttributeDefinition.Builder.fromSimpleParameter("frequency").build());
        buildingDefinitions.add(baseReconnectDefinition.withIdentifier("reconnect-forever").withSetterParameterDefinition("count", AttributeDefinition.Builder.fromFixedValue(-1).build()).build());
        buildingDefinitions.add(baseReconnectDefinition.withIdentifier("reconnect").withSetterParameterDefinition("retryNotifier", AttributeDefinition.Builder.fromChildConfiguration(RetryNotifier.class).build()).withSetterParameterDefinition("count", AttributeDefinition.Builder.fromSimpleParameter("count").build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("reconnection").withTypeDefinition(TypeDefinition.fromType(ReconnectionConfig.class)).withObjectFactoryType(ReconnectionConfigObjectFactory.class).withSetterParameterDefinition("failsDeployment", AttributeDefinition.Builder.fromSimpleParameter("failsDeployment").build()).withSetterParameterDefinition("retryPolicyTemplate", AttributeDefinition.Builder.fromChildConfiguration(RetryPolicyTemplate.class).build()).build());
        return buildingDefinitions;
    }

    private List<ComponentBuildingDefinition> getTransactionDefinitions() {
        ArrayList<ComponentBuildingDefinition> buildingDefinitions = new ArrayList<ComponentBuildingDefinition>();
        buildingDefinitions.add(baseDefinition.withIdentifier("xa-transaction").withTypeDefinition(TypeDefinition.fromType(MuleTransactionConfig.class)).withSetterParameterDefinition("factory", AttributeDefinition.Builder.fromFixedValue(new XaTransactionFactory()).build()).withSetterParameterDefinition("timeout", AttributeDefinition.Builder.fromSimpleParameter("timeout").build()).withSetterParameterDefinition("actionAsString", AttributeDefinition.Builder.fromSimpleParameter("action").build()).withSetterParameterDefinition("interactWithExternal", AttributeDefinition.Builder.fromSimpleParameter("interactWithExternal").build()).build());
        buildingDefinitions.add(baseDefinition.withIdentifier("environment").withTypeDefinition(TypeDefinition.fromType(Map.class)).withObjectFactoryType(EnvironmentPropertyObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleReferenceParameter("ref").build()).build());
        return buildingDefinitions;
    }

    private ComponentBuildingDefinition.Builder getCoreTransformerBaseBuilder(Class<? extends AbstractTransformer> transformerClass) {
        return ComponentBuildingDefinitionProviderUtils.getTransformerBaseBuilder(transformerClass, new KeyAttributeDefinitionPair[0]).withNamespace("mule");
    }

    private ComponentBuildingDefinition.Builder getCoreMuleMessageTransformerBaseBuilder() {
        return ComponentBuildingDefinitionProviderUtils.getMuleMessageTransformerBaseBuilder().withNamespace("mule");
    }

    private ComponentBuildingDefinition.Builder createTransactionManagerDefinitionBuilder(String transactionManagerName, Class<?> transactionManagerClass) {
        return this.transactionManagerBaseDefinition.withIdentifier(transactionManagerName).withTypeDefinition(TypeDefinition.fromType(transactionManagerClass));
    }

    private void addModuleOperationChainParser(LinkedList<ComponentBuildingDefinition> componentBuildingDefinitions) {
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("module-operation-chain").withTypeDefinition(TypeDefinition.fromType(AnnotatedProcessor.class)).withObjectFactoryType(ModuleOperationMessageProcessorChainFactoryBean.class).withSetterParameterDefinition("properties", AttributeDefinition.Builder.fromChildMapConfiguration(String.class, String.class).withWrapperIdentifier("module-operation-properties").build()).withSetterParameterDefinition("parameters", AttributeDefinition.Builder.fromChildMapConfiguration(String.class, String.class).withWrapperIdentifier("module-operation-parameters").build()).withSetterParameterDefinition("moduleName", AttributeDefinition.Builder.fromSimpleParameter("moduleName").build()).withSetterParameterDefinition("moduleOperation", AttributeDefinition.Builder.fromSimpleParameter("moduleOperation").build()).withSetterParameterDefinition(MESSAGE_PROCESSORS, AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build()).asPrototype().build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("module-operation-properties").withTypeDefinition(TypeDefinition.fromType(TreeMap.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("module-operation-property-entry").withTypeDefinition(TypeDefinition.fromMapEntryType(String.class, String.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("module-operation-parameters").withTypeDefinition(TypeDefinition.fromType(TreeMap.class)).build());
        componentBuildingDefinitions.add(baseDefinition.withIdentifier("module-operation-parameter-entry").withTypeDefinition(TypeDefinition.fromMapEntryType(String.class, String.class)).build());
    }
}

