/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.security;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.Credentials;

public class DefaultMuleAuthentication
implements Authentication {
    private final char[] credentials;
    private final String user;
    private final Map<String, Object> properties;

    public DefaultMuleAuthentication(Credentials credentials) {
        this.user = credentials.getUsername();
        this.credentials = credentials.getPassword();
        this.properties = null;
    }

    private DefaultMuleAuthentication(String user, char[] credentials, Map<String, Object> properties) {
        this.user = user;
        this.credentials = credentials;
        this.properties = properties != null ? Collections.unmodifiableMap(properties) : null;
    }

    @Override
    public Object getCredentials() {
        return new String(this.credentials);
    }

    @Override
    public Object getPrincipal() {
        return this.user;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public DefaultMuleAuthentication setProperties(Map<String, Object> properties) {
        return new DefaultMuleAuthentication(this.user, this.credentials, properties);
    }
}

