/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.Notification;
import org.mule.runtime.core.api.context.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.context.notification.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    protected static Logger logger = LoggerFactory.getLogger(Configuration.class);
    private Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> interfaceToTypes = new HashMap<Class<? extends NotificationListener>, Set<Class<? extends Notification>>>();
    private Set<ListenerSubscriptionPair> listenerSubscriptionPairs = new HashSet<ListenerSubscriptionPair>();
    private Set<Class<? extends NotificationListener>> disabledInterfaces = new HashSet<Class<? extends NotificationListener>>();
    private Set<Class<? extends Notification>> disabledNotificationTypes = new HashSet<Class<? extends Notification>>();
    private volatile boolean dirty = true;
    private Policy policy;

    public synchronized void addInterfaceToType(Class<? extends NotificationListener> iface, Class<? extends Notification> type) {
        this.dirty = true;
        if (!Notification.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(CoreMessages.propertyIsNotSupportedType("type", Notification.class, type).getMessage());
        }
        if (!this.interfaceToTypes.containsKey(iface)) {
            this.interfaceToTypes.put(iface, new HashSet());
        }
        Set<Class<? extends Notification>> events = this.interfaceToTypes.get(iface);
        events.add(type);
        if (logger.isDebugEnabled()) {
            logger.debug("Registered event type: " + type);
            logger.debug("Binding listener type '" + iface + "' to event type '" + type + "'");
        }
    }

    public synchronized void addAllInterfaceToTypes(Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> interfaceToTypes) throws ClassNotFoundException {
        this.dirty = true;
        for (Class<? extends NotificationListener> iface : interfaceToTypes.keySet()) {
            this.addInterfaceToType(ServerNotificationManager.toClass(iface), ServerNotificationManager.toClass(interfaceToTypes.get(iface)));
        }
    }

    public synchronized void addListenerSubscriptionPair(ListenerSubscriptionPair pair) {
        this.dirty = true;
        if (!this.listenerSubscriptionPairs.add(pair)) {
            logger.warn(CoreMessages.notificationListenerSubscriptionAlreadyRegistered(pair).toString());
        }
    }

    public synchronized void removeListener(NotificationListener listener) {
        this.dirty = true;
        HashSet<ListenerSubscriptionPair> toRemove = new HashSet<ListenerSubscriptionPair>();
        for (ListenerSubscriptionPair element : this.listenerSubscriptionPairs) {
            ListenerSubscriptionPair pair = element;
            if (!pair.getListener().equals(listener)) continue;
            toRemove.add(pair);
        }
        this.listenerSubscriptionPairs.removeAll(toRemove);
    }

    synchronized void removeAllListeners(Collection listeners) {
        this.dirty = true;
        Iterator listener = listeners.iterator();
        while (listener.hasNext()) {
            this.removeListener((NotificationListener)listener.next());
        }
    }

    public synchronized void disableInterface(Class<? extends NotificationListener> iface) {
        this.dirty = true;
        this.disabledInterfaces.add(iface);
    }

    public synchronized void disabledAllInterfaces(Collection<Class<? extends NotificationListener>> interfaces) throws ClassNotFoundException {
        this.dirty = true;
        for (Class<? extends NotificationListener> element : interfaces) {
            this.disableInterface(ServerNotificationManager.toClass(element));
        }
    }

    public synchronized void disableType(Class<? extends Notification> type) {
        this.dirty = true;
        this.disabledNotificationTypes.add(type);
    }

    synchronized void disableAllTypes(Collection types) throws ClassNotFoundException {
        this.dirty = true;
        Iterator event = types.iterator();
        while (event.hasNext()) {
            this.disableType(ServerNotificationManager.toClass(event.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy getPolicy() {
        if (this.dirty) {
            Configuration configuration = this;
            synchronized (configuration) {
                if (this.dirty) {
                    this.policy = new Policy(this.interfaceToTypes, this.listenerSubscriptionPairs, this.disabledInterfaces, this.disabledNotificationTypes);
                    this.dirty = false;
                }
            }
        }
        return this.policy;
    }

    public Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> getInterfaceToTypes() {
        return Collections.unmodifiableMap(this.interfaceToTypes);
    }

    public Set<ListenerSubscriptionPair> getListeners() {
        return Collections.unmodifiableSet(this.listenerSubscriptionPairs);
    }
}

