/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.NotificationDispatcher;
import org.mule.runtime.core.api.exception.DefaultErrorTypeRepository;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ErrorHandlerFactory;
import org.mule.runtime.core.internal.exception.MessagingExceptionStrategyAcceptorDelegate;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.internal.message.DefaultExceptionPayload;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ErrorHandler
extends AbstractMuleObjectOwner<MessagingExceptionHandlerAcceptor>
implements MessagingExceptionHandlerAcceptor,
MuleContextAware,
Lifecycle {
    private static final String MUST_ACCEPT_ANY_EVENT_MESSAGE = "Default exception strategy must accept any event.";
    private ErrorTypeMatcher criticalMatcher = new SingleErrorTypeMatcher(DefaultErrorTypeRepository.CRITICAL_ERROR_TYPE);
    private List<MessagingExceptionHandlerAcceptor> exceptionListeners;
    private String name;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.addDefaultExceptionStrategyIfRequired();
        this.validateConfiguredExceptionStrategies();
    }

    @Override
    public InternalEvent handleException(MessagingException exception, InternalEvent event) {
        event = this.addExceptionPayload(exception, event);
        if (this.isCriticalException(exception)) {
            return event;
        }
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.handleException(exception, event);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE));
    }

    @Override
    public Publisher<InternalEvent> apply(MessagingException exception) {
        if (this.isCriticalException(exception)) {
            return Mono.error((Throwable)exception);
        }
        InternalEvent event = this.addExceptionPayload(exception, exception.getEvent());
        exception.setProcessedEvent(event);
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.apply(exception);
        }
        return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE)));
    }

    @Override
    protected List<MessagingExceptionHandlerAcceptor> getOwnedObjects() {
        return this.exceptionListeners != null ? Collections.unmodifiableList(this.exceptionListeners) : Collections.emptyList();
    }

    @Override
    public boolean accept(InternalEvent event) {
        return true;
    }

    @Override
    public boolean acceptsAll() {
        return true;
    }

    private InternalEvent addExceptionPayload(MessagingException exception, InternalEvent event) {
        return InternalEvent.builder(event).message(InternalMessage.builder(event.getMessage()).exceptionPayload(new DefaultExceptionPayload(exception)).build()).build();
    }

    private boolean isCriticalException(MessagingException exception) {
        Optional<Error> error = exception.getEvent().getError();
        return error.isPresent() && this.criticalMatcher.match(error.get().getErrorType());
    }

    private void addDefaultExceptionStrategyIfRequired() throws InitialisationException {
        if (!this.exceptionListeners.get(this.exceptionListeners.size() - 1).acceptsAll()) {
            MessagingExceptionHandler defaultErrorHandler;
            String defaultErrorHandlerName = this.getMuleContext().getConfiguration().getDefaultErrorHandlerName();
            if (defaultErrorHandlerName != null && defaultErrorHandlerName.equals(this.name)) {
                this.logger.warn("Default 'error-handler' should include a final \"catch-all\" 'on-error-propagate'. Attempting implicit injection.");
                try {
                    defaultErrorHandler = new ErrorHandlerFactory().createDefault(this.muleContext.getRegistry().lookupObject(NotificationDispatcher.class));
                }
                catch (RegistrationException e) {
                    throw new InitialisationException(I18nMessageFactory.createStaticMessage("Could not inject \"catch-all\" handler in default 'error-handler'."), (Throwable)e, this);
                }
            }
            try {
                defaultErrorHandler = this.getMuleContext().getDefaultErrorHandler(Optional.of(this.getRootContainerName()));
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Failure initializing error-handler. If error-handler is defined as default one check that last exception strategy inside matches all errors"), (Throwable)e, this);
            }
            MessagingExceptionStrategyAcceptorDelegate acceptsAllStrategy = new MessagingExceptionStrategyAcceptorDelegate(defaultErrorHandler);
            LifecycleUtils.initialiseIfNeeded(acceptsAllStrategy, this.muleContext);
            this.exceptionListeners.add(acceptsAllStrategy);
        }
    }

    private void validateConfiguredExceptionStrategies() {
        this.validateOnlyLastAcceptsAll();
    }

    private void validateOnlyLastAcceptsAll() {
        for (int i = 0; i < this.exceptionListeners.size() - 1; ++i) {
            MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor = this.exceptionListeners.get(i);
            if (!messagingExceptionHandlerAcceptor.acceptsAll()) continue;
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only last exception strategy inside <error-handler> can accept any message. Maybe expression attribute is empty."));
        }
    }

    public void setExceptionListeners(List<MessagingExceptionHandlerAcceptor> exceptionListeners) {
        this.exceptionListeners = exceptionListeners;
    }

    public List<MessagingExceptionHandlerAcceptor> getExceptionListeners() {
        return Collections.unmodifiableList(this.exceptionListeners);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, this);
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!(exceptionListener instanceof TemplateOnErrorHandler)) continue;
            ((TemplateOnErrorHandler)exceptionListener).setRootContainerName(rootContainerName);
        }
    }
}

