/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.AsyncMessageNotification;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Scope;
import org.mule.runtime.core.api.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.session.DefaultMuleSession;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Scope,
Initialisable,
Startable,
Stoppable {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    private Registry registry;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProcessingStrategy processingStrategy;
    protected MessageProcessorChain delegate;
    private org.mule.runtime.api.scheduler.Scheduler scheduler;
    private Scheduler reactorScheduler;
    protected String name;

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate) {
        this.delegate = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChain delegate, String name) {
        this.delegate = delegate;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        Object rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).orElse(null);
        this.processingStrategy = rootContainer instanceof FlowConstruct ? ((FlowConstruct)rootContainer).getProcessingStrategy() : DirectProcessingStrategyFactory.DIRECT_PROCESSING_STRATEGY_INSTANCE;
        if (this.delegate == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        this.scheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation()));
        this.reactorScheduler = Schedulers.fromExecutorService((ExecutorService)this.scheduler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.reactorScheduler != null) {
            this.reactorScheduler.dispose();
            this.reactorScheduler = null;
        }
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).doOnNext(request -> Flux.just((Object)request).map(event -> this.asyncEvent((InternalEvent)request)).transform(innerPublisher -> Flux.from((Publisher)innerPublisher).doOnNext(this.fireAsyncScheduledNotification()).doOnNext(asyncRequest -> Flux.just((Object)asyncRequest).transform((Function)this.scheduleAsync(this.delegate)).doOnNext(event -> this.fireAsyncCompleteNotification((InternalEvent)event, null)).doOnError(MessagingException.class, e -> this.fireAsyncCompleteNotification(e.getEvent(), (MessagingException)e)).doOnError(throwable -> this.logger.warn("Error occurred during asynchronous processing at:" + this.getLocation().getLocation() + " . To handle this error include a <try> scope in the <async> scope.", throwable)).subscribe(event -> asyncRequest.getContext().success((InternalEvent)event), throwable -> asyncRequest.getContext().error((Throwable)throwable)))).subscribe(Operators.requestUnbounded()));
    }

    private ReactiveProcessor scheduleAsync(Processor delegate) {
        if (!this.processingStrategy.isSynchronous()) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)this.processingStrategy.onPipeline(delegate));
        }
        return publisher -> Flux.from((Publisher)publisher).transform((Function)delegate).subscribeOn(this.reactorScheduler);
    }

    private InternalEvent asyncEvent(InternalEvent event) {
        return InternalEvent.builder(DefaultEventContext.child(event.getContext(), Optional.ofNullable(this.getLocation())), event).replyToHandler(null).session(new DefaultMuleSession(event.getSession())).build();
    }

    private Consumer<InternalEvent> fireAsyncScheduledNotification() {
        return event -> this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(EnrichedNotificationInfo.createInfo(event, null, this), this.getLocation(), 1901));
    }

    private void fireAsyncCompleteNotification(InternalEvent event, MessagingException exception) {
        this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(EnrichedNotificationInfo.createInfo(event, exception, this), this.getLocation(), 1902));
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }
}

