/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ResponseMessageProcessorAdapter
extends AbstractInterceptingMessageProcessor
implements Lifecycle {
    protected Processor responseProcessor;

    public ResponseMessageProcessorAdapter() {
    }

    public ResponseMessageProcessorAdapter(Processor responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public void setProcessor(Processor processor) {
        this.responseProcessor = processor;
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        if (this.responseProcessor == null) {
            return publisher;
        }
        return Flux.from(publisher).transform((Function)this.applyNext()).flatMap(event -> Flux.from(MessageProcessors.processWithChildContext(event, this.responseProcessor, Optional.ofNullable(this.getLocation()))).defaultIfEmpty(event));
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.responseProcessor instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.responseProcessor)).setMuleContext(this.muleContext);
        }
        if (this.responseProcessor instanceof Initialisable) {
            ((Initialisable)((Object)this.responseProcessor)).initialise();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.responseProcessor instanceof Startable) {
            ((Startable)((Object)this.responseProcessor)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.responseProcessor instanceof Stoppable) {
            ((Stoppable)((Object)this.responseProcessor)).stop();
        }
    }

    @Override
    public void dispose() {
        if (this.responseProcessor instanceof Disposable) {
            ((Disposable)((Object)this.responseProcessor)).dispose();
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.responseProcessor, muleContext);
    }
}

