/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.ParametersResolverProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.MessagingExceptionResolver;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class ReactiveInterceptorAdapter
implements BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveInterceptorAdapter.class);
    private static final String INTERCEPTION_COMPONENT = "core:interceptionComponent";
    private static final String AROUND_METHOD_NAME = "around";
    @Inject
    private MuleContext muleContext;
    @Inject
    private ExtendedExpressionManager expressionManager;
    private ProcessorInterceptorFactory interceptorFactory;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public ReactiveProcessor apply(Processor component, ReactiveProcessor next) {
        ReactiveProcessor interceptedProcessor;
        if (!this.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((AnnotatedObject)((Object)component)).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ProcessorInterceptor interceptor = (ProcessorInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)((AnnotatedObject)((Object)component)).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        if (this.implementsAround(interceptor)) {
            LOGGER.info("Configuring interceptor '{}' around processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            interceptedProcessor = publisher -> Mono.from((Publisher)publisher).map(this.doBefore(interceptor, component, dslParameters)).flatMapMany(event -> Mono.fromFuture(this.doAround((InternalEvent)event, interceptor, component, dslParameters, next)).onErrorMap(CompletionException.class, completionException -> completionException.getCause())).onErrorMap(MessagingException.class, error -> this.createMessagingException(this.doAfter(interceptor, component, Optional.of(error.getCause())).apply(error.getEvent()), error.getCause(), (AnnotatedObject)((Object)component))).map(this.doAfter(interceptor, component, Optional.empty()));
        } else {
            LOGGER.info("Configuring interceptor '{}' before and after processor '{}'...", (Object)interceptor, (Object)componentLocation.getLocation());
            interceptedProcessor = publisher -> Mono.from((Publisher)publisher).map(this.doBefore(interceptor, component, dslParameters)).transform((Function)next).onErrorMap(MessagingException.class, error -> this.createMessagingException(this.doAfter(interceptor, component, Optional.of(error.getCause())).apply(error.getEvent()), error.getCause(), (AnnotatedObject)((Object)component))).map(this.doAfter(interceptor, component, Optional.empty()));
        }
        LOGGER.info("Interceptor '{}' for processor '{}' configured.", (Object)interceptor, (Object)componentLocation.getLocation());
        return interceptedProcessor;
    }

    private boolean implementsAround(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(AROUND_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Function<InternalEvent, InternalEvent> doBefore(ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling before() for '{}' in processor '{}'...", (Object)interceptor, (Object)((AnnotatedObject)((Object)component)).getLocation().getLocation());
            }
            try {
                interceptor.before(((AnnotatedObject)((Object)component)).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent);
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)new MessagingException(interceptionEvent.resolve(), e, (AnnotatedObject)((Object)component)));
            }
        };
    }

    private CompletableFuture<InternalEvent> doAround(InternalEvent event, ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters, ReactiveProcessor next) {
        InternalEvent eventWithResolvedParams = this.addResolvedParameters(event, component, dslParameters);
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next, component, this.muleContext.getErrorTypeLocator());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling around() for '{}' in processor '{}'...", (Object)interceptor, (Object)((AnnotatedObject)((Object)component)).getLocation().getLocation());
        }
        try {
            return ((CompletableFuture)interceptor.around(((AnnotatedObject)((Object)component)).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent, reactiveInterceptionAction).exceptionally(t -> {
                if (t instanceof MessagingException) {
                    throw new CompletionException((Throwable)t);
                }
                throw new CompletionException(this.createMessagingException(eventWithResolvedParams, t instanceof CompletionException ? t.getCause() : t, (AnnotatedObject)((Object)component)));
            })).thenApply(interceptedEvent -> ((DefaultInterceptionEvent)interceptedEvent).resolve());
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)this.createMessagingException(interceptionEvent.resolve(), e, (AnnotatedObject)((Object)component)));
        }
    }

    private Map<String, ProcessorParameterValue> getResolvedParams(InternalEvent eventWithResolvedParams) {
        return (Map)eventWithResolvedParams.getInternalParameters().get("core:interceptionResolvedParams");
    }

    private Function<InternalEvent, InternalEvent> doAfter(ProcessorInterceptor interceptor, Processor component, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Calling after() for '{}' in processor '{}'...", (Object)interceptor, (Object)((AnnotatedObject)((Object)component)).getLocation().getLocation());
            }
            try {
                interceptor.after(((AnnotatedObject)((Object)component)).getLocation(), interceptionEvent, thrown);
                return interceptionEvent.resolve();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)this.createMessagingException(interceptionEvent.resolve(), e, (AnnotatedObject)((Object)component)));
            }
        };
    }

    private boolean isInterceptable(Processor component) {
        return ((AnnotatedObject)((Object)component)).getLocation() != null;
    }

    private InternalEvent addResolvedParameters(InternalEvent event, Processor component, Map<String, String> dslParameters) {
        boolean sameComponent;
        boolean bl = sameComponent = event.getInternalParameters().containsKey(INTERCEPTION_COMPONENT) ? component.equals(event.getInternalParameters().get(INTERCEPTION_COMPONENT)) : false;
        if (!sameComponent || !event.getInternalParameters().containsKey("core:interceptionResolvedParams")) {
            return this.resolveParameters(this.removeResolvedParameters(event), component, dslParameters);
        }
        return event;
    }

    private InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (event.getInternalParameters().containsKey("core:interceptionResolvedContext") && (processor = (Processor)event.getInternalParameters().get(INTERCEPTION_COMPONENT)) instanceof ParametersResolverProcessor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disposing resolved parameters for processor {}...", (Object)((AnnotatedObject)((Object)processor)).getLocation().getLocation());
            }
            ((ParametersResolverProcessor)((Object)processor)).disposeResolvedParameters((ExecutionContext)event.getInternalParameters().get("core:interceptionResolvedContext"));
        }
        return InternalEvent.builder(event).removeInternalParameter("core:interceptionResolvedParams").removeInternalParameter(INTERCEPTION_COMPONENT).removeInternalParameter("core:interceptionResolvedContext").build();
    }

    private InternalEvent resolveParameters(InternalEvent event, Processor processor, Map<String, String> parameters) {
        HashMap<String, DefaultProcessorParameterValue> resolvedParameters = new HashMap<String, DefaultProcessorParameterValue>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    return this.expressionManager.evaluate(providedValue, event, ((AnnotatedObject)((Object)processor)).getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        InternalEvent.Builder builder = InternalEvent.builder(event);
        if (processor instanceof ParametersResolverProcessor) {
            try {
                ((ParametersResolverProcessor)((Object)processor)).resolveParameters(builder, (params, context) -> {
                    resolvedParameters.putAll(params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new DefaultProcessorParameterValue((String)e.getKey(), null, () -> e.getValue()))));
                    HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
                    interceptionEventParams.put("core:interceptionResolvedContext", context);
                    interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
                    interceptionEventParams.put(INTERCEPTION_COMPONENT, processor);
                    builder.internalParameters(interceptionEventParams);
                });
            }
            catch (MuleException e) {
                throw new InterceptionException(e);
            }
        } else {
            HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
            interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
            interceptionEventParams.put(INTERCEPTION_COMPONENT, processor);
            builder.internalParameters(interceptionEventParams);
        }
        return builder.build();
    }

    private MessagingException createMessagingException(InternalEvent event, Throwable cause, AnnotatedObject processor) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        MessagingException me = new MessagingException(event, cause, processor);
        return exceptionResolver.resolve(me, this.muleContext);
    }
}

