/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;

public class ParseTemplateProcessor
extends SimpleMessageProcessor {
    private String content;
    private String target;
    private String location;
    private String targetValue;

    @Override
    public void initialise() throws InitialisationException {
        if (this.content != null && this.location != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Can't define both location and content at the same time"), (Initialisable)this);
        }
        if (this.location != null) {
            this.loadContentFromLocation();
        }
    }

    private void loadContentFromLocation() throws InitialisationException {
        try {
            if (this.location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.content = IOUtils.getResourceAsString(this.location, this.getClass());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private void evaluateCorrectArguments() {
        if (this.content == null) {
            throw new IllegalArgumentException("Template content cannot be null");
        }
        if (this.targetValue != null && this.target == null) {
            throw new IllegalArgumentException("Can't define a targetValue with no target");
        }
    }

    @Override
    public InternalEvent process(InternalEvent event) {
        this.evaluateCorrectArguments();
        String result = this.muleContext.getExpressionManager().parse(this.content, event, null);
        Message resultMessage = Message.builder(event.getMessage()).value(result).nullAttributesValue().build();
        if (this.target == null) {
            return InternalEvent.builder(event).message(resultMessage).build();
        }
        if (this.targetValue == null) {
            return InternalEvent.builder(event).addVariable(this.target, resultMessage).build();
        }
        return InternalEvent.builder(event).addVariable(this.target, this.muleContext.getExpressionManager().evaluate(this.targetValue, InternalEvent.builder(event).message(resultMessage).build())).build();
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetValue(String targetValue) {
        this.targetValue = targetValue;
    }
}

