/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.collections.ListUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.management.stats.RouterStatistics;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.api.routing.RouterStatisticsRecorder;
import org.mule.runtime.core.api.routing.SelectiveRouter;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.routing.MessageProcessorExpressionPair;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class AbstractSelectiveRouter
extends AbstractAnnotatedObject
implements SelectiveRouter,
RouterStatisticsRecorder,
Lifecycle,
MuleContextAware {
    private final List<MessageProcessorExpressionPair> conditionalMessageProcessors = new ArrayList<MessageProcessorExpressionPair>();
    private Optional<Processor> defaultProcessor = Optional.empty();
    private RouterStatistics routerStatistics;
    final AtomicBoolean initialised = new AtomicBoolean(false);
    final AtomicBoolean starting = new AtomicBoolean(false);
    final AtomicBoolean started = new AtomicBoolean(false);
    private MuleContext muleContext;

    public AbstractSelectiveRouter() {
        this.routerStatistics = new RouterStatistics(2);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (o instanceof MuleContextAware) {
                    ((MuleContextAware)o).setMuleContext(this.muleContext);
                }
                if (!(o instanceof Initialisable)) continue;
                ((Initialisable)o).initialise();
            }
        }
        this.initialised.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            this.starting.set(true);
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Startable)) continue;
                ((Startable)o).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Stoppable)) continue;
                ((Stoppable)o).stop();
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Disposable)) continue;
                ((Disposable)o).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(String expression, Processor processor) {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            MessageProcessorExpressionPair addedPair = new MessageProcessorExpressionPair(expression, processor);
            this.conditionalMessageProcessors.add(this.transitionLifecycleManagedObjectForAddition(addedPair));
        }
    }

    @Override
    public void removeRoute(Processor processor) {
        this.updateRoute(processor, (int index) -> {
            MessageProcessorExpressionPair removedPair = this.conditionalMessageProcessors.remove(index);
            this.transitionLifecycleManagedObjectForRemoval(removedPair);
        });
    }

    @Override
    public void updateRoute(String expression, Processor processor) {
        this.updateRoute(processor, (int index) -> {
            MessageProcessorExpressionPair addedPair = new MessageProcessorExpressionPair(expression, processor);
            MessageProcessorExpressionPair removedPair = this.conditionalMessageProcessors.set(index, this.transitionLifecycleManagedObjectForAddition(addedPair));
            this.transitionLifecycleManagedObjectForRemoval(removedPair);
        });
    }

    @Override
    public void setDefaultRoute(Processor processor) {
        this.defaultProcessor = Optional.ofNullable(processor);
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Flux.from(publisher).flatMap(Exceptions.checkedFunction(event -> {
            Processor processor = this.getProcessorToRoute((InternalEvent)event);
            return Flux.just((Object)event).transform((Function)processor).doOnComplete(() -> this.updateStatistics(processor));
        }));
    }

    protected Processor getProcessorToRoute(InternalEvent event) throws RoutePathNotFoundException {
        Optional<Processor> selectedProcessor = this.selectProcessor(event);
        return (selectedProcessor.isPresent() ? selectedProcessor : this.defaultProcessor).orElseThrow(() -> new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("Can't process message because no route has been found matching any filter and no default route is defined"), this));
    }

    protected abstract Optional<Processor> selectProcessor(InternalEvent var1);

    private Collection<?> getLifecycleManagedObjects() {
        if (!this.defaultProcessor.isPresent()) {
            return this.conditionalMessageProcessors;
        }
        return ListUtils.union(this.conditionalMessageProcessors, Collections.singletonList(this.defaultProcessor.get()));
    }

    private <O> O transitionLifecycleManagedObjectForAddition(O managedObject) {
        try {
            if (this.muleContext != null && managedObject instanceof MuleContextAware) {
                ((MuleContextAware)managedObject).setMuleContext(this.muleContext);
            }
            if (this.initialised.get() && managedObject instanceof Initialisable) {
                ((Initialisable)managedObject).initialise();
            }
            if (this.started.get() && managedObject instanceof Startable) {
                ((Startable)managedObject).start();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    private <O> O transitionLifecycleManagedObjectForRemoval(O managedObject) {
        try {
            if (managedObject instanceof Stoppable) {
                ((Stoppable)managedObject).stop();
            }
            if (managedObject instanceof Disposable) {
                ((Disposable)managedObject).dispose();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    public void updateStatistics(Processor processor) {
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(processor);
        }
    }

    public List<MessageProcessorExpressionPair> getConditionalMessageProcessors() {
        return Collections.unmodifiableList(this.conditionalMessageProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoute(Processor processor, RoutesUpdater routesUpdater) {
        List<MessageProcessorExpressionPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (int i = 0; i < this.conditionalMessageProcessors.size(); ++i) {
                if (!this.conditionalMessageProcessors.get(i).getMessageProcessor().equals(processor)) continue;
                routesUpdater.updateAt(i);
            }
        }
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public String toString() {
        return String.format("%s [flow=%s, started=%s]", this.getClass().getSimpleName(), this.getLocation().getRootContainerName(), this.started);
    }

    private static interface RoutesUpdater {
        public void updateAt(int var1);
    }
}

