/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.DuplicateMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentMessageValidator
extends AbstractAnnotatedObject
implements Processor,
MuleContextAware,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentMessageValidator.class);
    protected MuleContext muleContext;
    protected volatile ObjectStore<String> store;
    protected String storePrefix;
    protected String idExpression = String.format("%s%s%s", "#[", "correlationId", "]");
    protected String valueExpression = String.format("%s%s%s", "#[", "correlationId", "]");

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s.%s.%s", this.muleContext.getConfiguration().getId(), this.getLocation().getRootContainerName(), this.getClass().getName());
        }
        if (this.store == null) {
            this.store = this.createMessageIdStore();
        }
        LifecycleUtils.initialiseIfNeeded(this.store);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.store, LOGGER);
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        return objectStoreManager.createObjectStore(this.storePrefix, ObjectStoreSettings.builder().persistent(false).entryTtl(TimeUnit.MINUTES.toMillis(5L)).expirationInterval(TimeUnit.SECONDS.toMillis(6L)).build());
    }

    protected String getValueForEvent(InternalEvent event) throws MessagingException {
        return (String)this.muleContext.getExpressionManager().evaluate(this.valueExpression, DataType.STRING, BindingContextUtils.NULL_BINDING_CONTEXT, event).getValue();
    }

    protected String getIdForEvent(InternalEvent event) throws MuleException {
        return (String)this.muleContext.getExpressionManager().evaluate(this.idExpression, DataType.STRING, BindingContextUtils.NULL_BINDING_CONTEXT, event).getValue();
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public ObjectStore<String> getObjectStore() {
        return this.store;
    }

    public void setObjectStore(ObjectStore<String> store) {
        this.store = store;
    }

    private boolean accept(InternalEvent event) {
        if (event != null && this.isNewMessage(event)) {
            try {
                String id = this.getIdForEvent(event);
                String value = this.getValueForEvent(event);
                try {
                    this.store.store(id, value);
                    return true;
                }
                catch (ObjectAlreadyExistsException ex) {
                    return false;
                }
                catch (ObjectStoreNotAvailableException e) {
                    LOGGER.error("ObjectStore not available: " + e.getMessage());
                    return false;
                }
                catch (ObjectStoreException e) {
                    LOGGER.warn("ObjectStore exception: " + e.getMessage());
                    return false;
                }
            }
            catch (MuleException e) {
                LOGGER.warn("Could not retrieve Id or Value for event: " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public final InternalEvent process(InternalEvent event) throws MuleException {
        if (this.accept(event)) {
            return event;
        }
        throw new DuplicateMessageException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNewMessage(InternalEvent event) {
        try {
            String id = this.getIdForEvent(event);
            if (this.store == null) {
                IdempotentMessageValidator idempotentMessageValidator = this;
                synchronized (idempotentMessageValidator) {
                    this.initialise();
                }
            }
            return !this.store.contains(id);
        }
        catch (MuleException e) {
            LOGGER.error("Exception attempting to determine idempotency of incoming message for " + this.getLocation().getRootContainerName() + " from the connector " + event.getContext().getOriginatingLocation().getComponentIdentifier().getIdentifier().getNamespace(), (Throwable)e);
            return false;
        }
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }
}

