/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.util.queue.AbstractQueueStoreDelegate;
import org.mule.runtime.core.internal.util.queue.QueueControlDataFile;
import org.mule.runtime.core.internal.util.queue.QueueFileProvider;
import org.mule.runtime.core.internal.util.queue.RandomAccessFileQueueStore;
import org.mule.runtime.core.internal.util.queue.RawDataSelector;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueStoreDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DualRandomAccessFileQueueStoreDelegate
extends AbstractQueueStoreDelegate
implements TransactionalQueueStoreDelegate {
    public static final String MAX_LENGTH_PER_FILE_PROPERTY_KEY = "mule.queue.maxlength";
    private static final int ONE_MEGABYTE = 0x100000;
    private static final String QUEUE_STORE_DIRECTORY = "queuestore";
    private static final Integer MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES = Integer.valueOf(System.getProperty("mule.queue.maxlength", Integer.valueOf(0x100000).toString()));
    private static final String QUEUE_STORE_1_SUFFIX = "-1";
    private static final String QUEUE_STORE_2_SUFFIX = "-2";
    private static final Object QUEUE_DATA_CONTROL_SUFFIX = "-crl";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MuleContext muleContext;
    private final ObjectSerializer serializer;
    private final ReadWriteLock filesLock;
    private final QueueControlDataFile queueControlDataFile;
    private RandomAccessFileQueueStore writeFile;
    private RandomAccessFileQueueStore readFile;
    private RandomAccessFileQueueStore randomAccessFileQueueStore1;
    private RandomAccessFileQueueStore randomAccessFileQueueStore2;

    public DualRandomAccessFileQueueStoreDelegate(String queueName, String workingDirectory, MuleContext muleContext, int capacity) {
        super(capacity);
        this.muleContext = muleContext;
        this.serializer = muleContext.getObjectSerializer();
        File queuesDirectory = DualRandomAccessFileQueueStoreDelegate.getQueuesDirectory(workingDirectory);
        if (!queuesDirectory.exists()) {
            Preconditions.checkState(queuesDirectory.mkdirs(), "Could not create queue store directory " + queuesDirectory.getAbsolutePath());
        }
        this.randomAccessFileQueueStore1 = new RandomAccessFileQueueStore(new QueueFileProvider(queuesDirectory, queueName + QUEUE_STORE_1_SUFFIX));
        this.randomAccessFileQueueStore2 = new RandomAccessFileQueueStore(new QueueFileProvider(queuesDirectory, queueName + QUEUE_STORE_2_SUFFIX));
        this.queueControlDataFile = new QueueControlDataFile(new QueueFileProvider(queuesDirectory, queueName + QUEUE_DATA_CONTROL_SUFFIX), this.randomAccessFileQueueStore1.getFile(), this.randomAccessFileQueueStore2.getFile());
        this.writeFile = this.queueControlDataFile.getCurrentWriteFile().getAbsolutePath().equals(this.randomAccessFileQueueStore1.getFile().getAbsolutePath()) ? this.randomAccessFileQueueStore1 : this.randomAccessFileQueueStore2;
        this.readFile = this.queueControlDataFile.getCurrentReadFile().getAbsolutePath().equals(this.randomAccessFileQueueStore1.getFile().getAbsolutePath()) ? this.randomAccessFileQueueStore1 : this.randomAccessFileQueueStore2;
        this.filesLock = new ReentrantReadWriteLock();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Queue %s has %s messages", queueName, this.getSize()));
        }
    }

    QueueControlDataFile getQueueControlDataFile() {
        return this.queueControlDataFile;
    }

    private static File getQueuesDirectory(String workingDirectory) {
        return new File(workingDirectory + File.separator + QUEUE_STORE_DIRECTORY);
    }

    public static File getFirstQueueFileForTesting(String queueName, String workingDirectory) {
        return new File(DualRandomAccessFileQueueStoreDelegate.getQueuesDirectory(workingDirectory), queueName + QUEUE_STORE_1_SUFFIX);
    }

    @Override
    protected void addFirst(Serializable item) throws InterruptedException {
        this.switchWriteFileIfFull();
        byte[] serialiazedObject = this.serializer.getInternalProtocol().serialize(item);
        this.readFile.addFirst(serialiazedObject);
    }

    @Override
    protected void add(Serializable item) {
        this.switchWriteFileIfFull();
        byte[] serialiazedObject = this.serializer.getInternalProtocol().serialize(item);
        this.writeFile.addLast(serialiazedObject);
    }

    @Override
    protected Serializable removeFirst() throws InterruptedException {
        Serializable value = this.getFirst();
        if (value != null) {
            this.readFile.removeFirst();
        }
        return value;
    }

    @Override
    protected Serializable getFirst() throws InterruptedException {
        byte[] bytes;
        if (this.isEmpty()) {
            return null;
        }
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            if (this.readFile.isEmpty()) {
                this.readFile.clear();
                this.switchReadFile();
            }
            bytes = this.readFile.getFirst();
        }
        finally {
            lock.unlock();
        }
        return this.deserialize(bytes);
    }

    @Override
    public int size() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            int n = this.randomAccessFileQueueStore1.getSize() + this.randomAccessFileQueueStore2.getSize();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected boolean isEmpty() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            boolean bl = this.randomAccessFileQueueStore1.isEmpty() && this.randomAccessFileQueueStore2.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void doClear() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            this.randomAccessFileQueueStore1.clear();
            this.randomAccessFileQueueStore2.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doAddAll(Collection<? extends Serializable> items) {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            for (Serializable serializable : items) {
                this.add(serializable);
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    public Collection<Serializable> allElements() {
        LinkedList<Serializable> elements = new LinkedList<Serializable>();
        elements.addAll(this.deserializeValues(this.randomAccessFileQueueStore1.allElements()));
        elements.addAll(this.deserializeValues(this.randomAccessFileQueueStore2.allElements()));
        return elements;
    }

    private Collection<Serializable> deserializeValues(Collection<byte[]> valuesAsBytes) {
        ArrayList<Serializable> values = new ArrayList<Serializable>(valuesAsBytes.size());
        for (byte[] valueAsByte : valuesAsBytes) {
            try {
                values.add(this.deserialize(valueAsByte));
            }
            catch (Exception e) {
                this.logger.warn("Failure trying to deserialize value " + e.getMessage());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Failure trying to deserialize value", (Throwable)e);
            }
        }
        return values;
    }

    private Serializable deserialize(byte[] valuesAsBytes) {
        return (Serializable)this.serializer.getInternalProtocol().deserialize(valuesAsBytes);
    }

    @Override
    public void remove(Serializable value) {
        RawDataSelector rawDataSelector = this.createDataSelector(value);
        if (!this.randomAccessFileQueueStore1.remove(rawDataSelector)) {
            this.randomAccessFileQueueStore2.remove(rawDataSelector);
        }
    }

    private RawDataSelector createDataSelector(final Serializable value) {
        return new RawDataSelector(){

            @Override
            public boolean isSelectedData(byte[] data) {
                return DualRandomAccessFileQueueStoreDelegate.this.deserialize(data).equals(value);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Serializable value) {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            RawDataSelector dataSelector = this.createDataSelector(value);
            if (!this.randomAccessFileQueueStore1.contains(dataSelector)) {
                boolean bl = this.randomAccessFileQueueStore2.contains(dataSelector);
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    @Override
    public void close() {
        Lock lock = this.filesLock.readLock();
        lock.lock();
        try {
            this.doClose();
        }
        finally {
            lock.unlock();
        }
    }

    private void switchReadFile() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("switching read file. Random 1 size: " + this.randomAccessFileQueueStore1.getSize() + " , Random 2 size: " + this.randomAccessFileQueueStore2.getSize());
        }
        this.readFile = this.nextReadFile();
        this.queueControlDataFile.writeControlData(this.writeFile.getFile(), this.readFile.getFile());
    }

    private void switchWriteFileIfFull() {
        if (this.writeFile.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
            Lock lock = this.filesLock.writeLock();
            lock.lock();
            try {
                if (this.writeFile.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
                    if (this.randomAccessFileQueueStore1.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue() && this.randomAccessFileQueueStore2.getLength() >= (long)MAXIMUM_QUEUE_FILE_SIZE_IN_BYTES.intValue()) {
                        return;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("switching write file. Random 1 size: " + this.randomAccessFileQueueStore1.getLength() + " , Random 2 size: " + this.randomAccessFileQueueStore2.getLength());
                    }
                    this.writeFile = this.writeFile == this.randomAccessFileQueueStore1 ? this.randomAccessFileQueueStore2 : this.randomAccessFileQueueStore1;
                    this.queueControlDataFile.writeControlData(this.writeFile.getFile(), this.readFile.getFile());
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private RandomAccessFileQueueStore nextReadFile() {
        return this.readFile == this.randomAccessFileQueueStore1 ? this.randomAccessFileQueueStore2 : this.randomAccessFileQueueStore1;
    }

    @Override
    public void dispose() {
        Lock lock = this.filesLock.writeLock();
        lock.lock();
        try {
            this.doClose();
            this.delete();
        }
        finally {
            lock.unlock();
        }
    }

    private void delete() {
        Lock lock = this.filesLock.writeLock();
        lock.lock();
        try {
            this.randomAccessFileQueueStore1.delete();
            this.randomAccessFileQueueStore2.delete();
            this.queueControlDataFile.delete();
        }
        finally {
            lock.unlock();
        }
    }

    private void doClose() {
        this.randomAccessFileQueueStore1.close();
        this.randomAccessFileQueueStore2.close();
        this.queueControlDataFile.close();
    }
}

