/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.List;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorePartition<T extends Serializable>
extends TemplateObjectStore<T>
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectStorePartition.class);
    private final String partitionName;
    private final PartitionableObjectStore<T> partitionedObjectStore;

    public ObjectStorePartition(String partitionName, PartitionableObjectStore<T> partitionedObjectStore) {
        this.partitionName = partitionName;
        this.partitionedObjectStore = partitionedObjectStore;
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.partitionedObjectStore, LOGGER);
    }

    @Override
    protected boolean doContains(String key) throws ObjectStoreException {
        return this.partitionedObjectStore.contains(key, this.partitionName);
    }

    @Override
    protected void doStore(String key, T value) throws ObjectStoreException {
        this.partitionedObjectStore.store(key, value, this.partitionName);
    }

    @Override
    protected T doRetrieve(String key) throws ObjectStoreException {
        return this.partitionedObjectStore.retrieve(key, this.partitionName);
    }

    @Override
    public void clear() throws ObjectStoreException {
        this.partitionedObjectStore.clear(this.partitionName);
    }

    @Override
    protected T doRemove(String key) throws ObjectStoreException {
        return this.partitionedObjectStore.remove(key, this.partitionName);
    }

    @Override
    public boolean isPersistent() {
        return this.partitionedObjectStore.isPersistent();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.partitionedObjectStore.open(this.partitionName);
    }

    @Override
    public void close() throws ObjectStoreException {
        this.partitionedObjectStore.close(this.partitionName);
    }

    @Override
    public List<String> allKeys() throws ObjectStoreException {
        return this.partitionedObjectStore.allKeys(this.partitionName);
    }

    public PartitionableObjectStore<T> getBaseStore() {
        return this.partitionedObjectStore;
    }

    public String getPartitionName() {
        return this.partitionName;
    }
}

