/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CompositeProcessorChainRouter
extends AbstractExecutableComponent
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(CompositeProcessorChainRouter.class);
    @Inject
    private MuleContext muleContext;
    private String name;
    private List<MessageProcessorChain> processorChains = Collections.emptyList();
    private MessageProcessorChain messageProcessorChain;

    public void setProcessorChains(List processorChains) {
        this.processorChains = processorChains;
    }

    @Override
    protected Function<Publisher<InternalEvent>, Publisher<InternalEvent>> getExecutableFunction() {
        return publisher -> Mono.from((Publisher)publisher).transform((Function)this.messageProcessorChain);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messageProcessorChain);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messageProcessorChain, LOGGER);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messageProcessorChain);
    }

    @Override
    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
        for (MessageProcessorChain processorChain : this.processorChains) {
            chainBuilder.chain(processorChain);
        }
        this.messageProcessorChain = chainBuilder.build();
        LifecycleUtils.initialiseIfNeeded(this.messageProcessorChain, this.muleContext);
    }
}

