/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.MessagingExceptionResolver;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractMessageProcessorChain
extends AbstractExecutableComponent
implements MessageProcessorChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
    private final String name;
    private final List<Processor> processors;
    private ProcessingStrategy processingStrategy;
    private StreamingManager streamingManager;

    AbstractMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors) {
        this.name = name;
        this.processingStrategy = processingStrategyOptional.orElse(null);
        this.processors = processors;
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = this.resolveInterceptors();
        Flux stream = Flux.from(publisher);
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor));
        }
        return stream;
    }

    private ReactiveProcessor applyInterceptors(List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (BiFunction<Processor, ReactiveProcessor, ReactiveProcessor> interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> resolveInterceptors() {
        ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>> interceptors = new ArrayList<BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).onErrorMap(MessagingException.class, this.resolveMessagingException((Processor)processor)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(event -> InternalEvent.setCurrentEvent(event)).transform((Function)next));
        if (this.processingStrategy != null) {
            interceptors.add((processor, next) -> this.processingStrategy.onProcessor(new ReactiveProcessor((ReactiveProcessor)next, (Processor)processor){
                final /* synthetic */ ReactiveProcessor val$next;
                final /* synthetic */ Processor val$processor;
                {
                    this.val$next = reactiveProcessor;
                    this.val$processor = processor;
                }

                @Override
                public Publisher<InternalEvent> apply(Publisher<InternalEvent> eventPublisher) {
                    return (Publisher)this.val$next.apply(eventPublisher);
                }

                @Override
                public ReactiveProcessor.ProcessingType getProcessingType() {
                    return this.val$processor.getProcessingType();
                }
            }));
        }
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).doOnNext(result -> InternalEvent.setCurrentEvent(result)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(this.preNotification((Processor)processor)).transform((Function)next).doOnNext(this.postNotification((Processor)processor)).doOnError(MessagingException.class, this.errorNotification((Processor)processor)));
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).transform((Function)next).map(StreamingUtils.updateEventForStreaming(this.streamingManager)));
        this.muleContext.getProcessorInterceptorManager().getInterceptorFactories().stream().forEach(interceptorFactory -> {
            ReactiveInterceptorAdapter reactiveInterceptorAdapter = new ReactiveInterceptorAdapter((ProcessorInterceptorFactory)interceptorFactory);
            try {
                this.muleContext.getInjector().inject(reactiveInterceptorAdapter);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
            interceptors.add(0, reactiveInterceptorAdapter);
        });
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).concatMap(event -> Flux.just((Object)event).transform((Function)next).onErrorResume(RejectedExecutionException.class, throwable -> Mono.from(event.getContext().error(this.resolveException((AnnotatedObject)((Object)processor), (InternalEvent)event, (Throwable)throwable))).then(Mono.empty())).onErrorResume(MessagingException.class, throwable -> {
            throwable = this.resolveMessagingException((Processor)processor).apply((MessagingException)throwable);
            return Mono.from(event.getContext().error((Throwable)throwable)).then(Mono.empty());
        })));
        return interceptors;
    }

    private MessagingException resolveException(AnnotatedObject processor, InternalEvent event, Throwable throwable) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        return exceptionResolver.resolve(new MessagingException(event, throwable, processor), this.muleContext);
    }

    private Function<MessagingException, MessagingException> resolveMessagingException(Processor processor) {
        if (processor instanceof AnnotatedObject) {
            MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver((AnnotatedObject)((Object)processor));
            return exception -> exceptionResolver.resolve((MessagingException)exception, this.muleContext);
        }
        return exception -> exception;
    }

    private Consumer<InternalEvent> preNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (InternalEvent)event, processor, null, 1601);
            }
        };
    }

    private Consumer<InternalEvent> postNotification(Processor processor) {
        return event -> {
            if (event.isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), (InternalEvent)event, processor, null, 1602);
            }
        };
    }

    private Consumer<MessagingException> errorNotification(Processor processor) {
        return exception -> {
            if (exception.getEvent().isNotificationsEnabled()) {
                this.fireNotification(this.muleContext.getNotificationManager(), exception.getEvent(), processor, (MessagingException)exception, 1602);
            }
        };
    }

    private void fireNotification(ServerNotificationManager serverNotificationManager, InternalEvent event, Processor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && ((AnnotatedObject)((Object)processor)).getLocation() != null) {
            serverNotificationManager.fireNotification(MessageProcessorNotification.createFrom(event, ((AnnotatedObject)((Object)processor)).getLocation(), (AnnotatedObject)((Object)processor), exceptionThrown, action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.streamingManager = this.muleContext.getRegistry().lookupObject(StreamingManager.class);
        }
        catch (RegistrationException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
    }

    @Override
    protected Optional<FlowConstruct> getFlowConstruct() {
        Object object = this.muleContext.getRegistry().get(this.getRootContainerName());
        return object instanceof FlowConstruct ? Optional.of((FlowConstruct)object) : Optional.empty();
    }
}

