/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.domain.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainClassLoaderFactory
implements DeployableArtifactClassLoaderFactory<DomainDescriptor> {
    protected static final Logger logger = LoggerFactory.getLogger(DomainClassLoaderFactory.class);
    private final ClassLoader containerClassLoader;
    private Map<String, ArtifactClassLoader> domainArtifactClassLoaders = new HashMap<String, ArtifactClassLoader>();

    public DomainClassLoaderFactory(ClassLoader containerClassLoader) {
        Preconditions.checkArgument(containerClassLoader != null, "parentClassLoader cannot be null");
        this.containerClassLoader = containerClassLoader;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainName), "domainName cannot be empty");
        return "domain/" + domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactClassLoader create(String artifactId, ArtifactClassLoader parent, DomainDescriptor descriptor, List<ArtifactClassLoader> artifactClassLoaders) {
        String domainId = DomainClassLoaderFactory.getDomainId(descriptor.getName());
        ArtifactClassLoader domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
        if (domainClassLoader != null) {
            return domainClassLoader;
        }
        DomainClassLoaderFactory domainClassLoaderFactory = this;
        synchronized (domainClassLoaderFactory) {
            domainClassLoader = this.domainArtifactClassLoaders.get(domainId);
            if (domainClassLoader == null) {
                domainClassLoader = descriptor.getName().equals("default") ? this.getDefaultDomainClassLoader(parent.getClassLoaderLookupPolicy()) : this.getCustomDomainClassLoader(parent, descriptor, artifactClassLoaders);
                this.domainArtifactClassLoaders.put(domainId, domainClassLoader);
            }
        }
        return domainClassLoader;
    }

    private ArtifactClassLoader getCustomDomainClassLoader(ArtifactClassLoader parent, DomainDescriptor domain, List<ArtifactClassLoader> artifactClassLoaders) {
        this.validateDomain(domain.getName());
        ClassLoaderLookupPolicy classLoaderLookupPolicy = this.getApplicationClassLoaderLookupPolicy(parent, domain);
        MuleSharedDomainClassLoader classLoader = new MuleSharedDomainClassLoader(domain, parent.getClassLoader(), classLoaderLookupPolicy, Arrays.asList(domain.getClassLoaderModel().getUrls()), artifactClassLoaders);
        return classLoader;
    }

    private ClassLoaderLookupPolicy getApplicationClassLoaderLookupPolicy(ArtifactClassLoader parent, DomainDescriptor descriptor) {
        HashMap<String, LookupStrategy> pluginsLookupStrategies = new HashMap<String, LookupStrategy>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(p -> pluginsLookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parent.getClassLoaderLookupPolicy().extend(pluginsLookupStrategies);
    }

    private ArtifactClassLoader getDefaultDomainClassLoader(ClassLoaderLookupPolicy containerLookupPolicy) {
        return new MuleSharedDomainClassLoader(new DomainDescriptor("default"), this.containerClassLoader, containerLookupPolicy.extend(Collections.emptyMap()), Collections.emptyList(), Collections.emptyList());
    }

    private void validateDomain(String domain) {
        File domainFolder = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domain);
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("Domain %s does not exists", domain)));
        }
    }
}

