/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;

public final class RedeliveryPolicyTypeBuilder
extends InfrastructureTypeBuilder {
    public static final String MAX_REDELIVERY_COUNT = "maxRedeliveryCount";
    public static final String USE_SECURE_HASH = "useSecureHash";
    public static final String MESSAGE_DIGEST_ALGORITHM = "messageDigestAlgorithm";
    public static final String ID_EXPRESSION = "idExpression";
    public static final String OBJECT_STORE_REF = "object-store-ref";
    public static final String REDELIVERY_POLICY = "RedeliveryPolicy";

    public MetadataType buildRedeliveryPolicyType() {
        ObjectTypeBuilder objectType = BaseTypeBuilder.create(MetadataFormat.JAVA).objectType().id(REDELIVERY_POLICY);
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        objectType.with(new InfrastructureTypeAnnotation());
        this.addIntField(objectType, typeBuilder, MAX_REDELIVERY_COUNT, "The maximum number of times a message can be redelivered and processed unsuccessfully before triggering process-failed-message", 5);
        this.addBooleanField(objectType, typeBuilder, USE_SECURE_HASH, "Whether to use a secure hash algorithm to identify a redelivered message", true);
        this.addStringField(objectType, typeBuilder, MESSAGE_DIGEST_ALGORITHM, "The secure hashing algorithm to use. If not set, the default is SHA-256.", null);
        this.addStringField(objectType, typeBuilder, ID_EXPRESSION, "Defines one or more expressions to use to determine when a message has been redelivered. This property may only be set if useSecureHash is false.", null);
        this.addStringField(objectType, typeBuilder, OBJECT_STORE_REF, "The object store where the redelivery counter for each message is going to be stored.", null);
        return objectType.build();
    }
}

