/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.connection.CompositeConnectionManager;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.deployment.model.api.DeployableArtifact;

public class ConnectionManagerConfigurationBuilder
implements ConfigurationBuilder {
    private final CheckedConsumer<MuleContext> muleContextConfigurer;
    private boolean isConfigured = false;

    ConnectionManagerConfigurationBuilder(DeployableArtifact parentArtifact) {
        Preconditions.checkNotNull(parentArtifact, "'parentArtifact' can't be null");
        this.muleContextConfigurer = muleContext -> {
            ConnectionManagerAdapter parentConnectionManager = (ConnectionManagerAdapter)parentArtifact.getMuleContext().getRegistry().get("_muleConnectionManager");
            if (parentConnectionManager != null) {
                CompositeConnectionManager connectionManager = new CompositeConnectionManager(new DefaultConnectionManager((MuleContext)muleContext), parentConnectionManager);
                this.registerConnectionManager((MuleContext)muleContext, connectionManager);
            } else {
                this.registerDefaultConnectionManager((MuleContext)muleContext);
            }
            this.isConfigured = true;
        };
    }

    ConnectionManagerConfigurationBuilder() {
        this.muleContextConfigurer = muleContext -> {
            this.registerDefaultConnectionManager((MuleContext)muleContext);
            this.isConfigured = true;
        };
    }

    @Override
    public void configure(MuleContext muleContext) throws ConfigurationException {
        try {
            this.muleContextConfigurer.acceptChecked(muleContext);
        }
        catch (Throwable e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage("An error occurred trying to register the Mule Connection Manager"), e);
        }
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    private void registerDefaultConnectionManager(MuleContext muleContext) throws RegistrationException {
        this.registerConnectionManager(muleContext, new DefaultConnectionManager(muleContext));
    }

    private void registerConnectionManager(MuleContext muleContext, ConnectionManager connectionManager) throws RegistrationException {
        muleContext.getRegistry().registerObject("_muleConnectionManager", connectionManager);
    }

    @Override
    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
    }
}

