/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderModelLoader;
import org.mule.runtime.module.service.LibFolderClassLoaderModelLoader;

public class MavenClassLoaderModelLoader
implements ClassLoaderModelLoader {
    private DeployableMavenClassLoaderModelLoader deployableMavenClassLoaderModelLoader;
    private PluginMavenClassLoaderModelLoader pluginMavenClassLoaderModelLoader;
    private LibFolderClassLoaderModelLoader libFolderClassLoaderModelLoader;
    private final MavenClientProvider mavenClientProvider;
    private MavenConfiguration mavenRuntimeConfig;
    private StampedLock lock = new StampedLock();

    public MavenClassLoaderModelLoader() {
        this.mavenClientProvider = MavenClientProvider.discoverProvider(MavenClientProvider.class.getClassLoader());
        this.mavenRuntimeConfig = GlobalConfigLoader.getMavenConfig();
        this.createClassLoaderModelLoaders();
    }

    private void createClassLoaderModelLoaders() {
        MavenClient mavenClient = this.mavenClientProvider.createMavenClient(this.mavenRuntimeConfig);
        this.deployableMavenClassLoaderModelLoader = new DeployableMavenClassLoaderModelLoader(mavenClient, this.mavenClientProvider.getLocalRepositorySuppliers());
        this.pluginMavenClassLoaderModelLoader = new PluginMavenClassLoaderModelLoader(mavenClient, this.mavenClientProvider.getLocalRepositorySuppliers());
        this.libFolderClassLoaderModelLoader = new LibFolderClassLoaderModelLoader();
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        long stamp = this.lock.readLock();
        try {
            MavenConfiguration updatedMavenConfiguration = GlobalConfigLoader.getMavenConfig();
            if (!this.mavenRuntimeConfig.equals(updatedMavenConfiguration)) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (!this.mavenRuntimeConfig.equals(updatedMavenConfiguration)) {
                    this.mavenRuntimeConfig = updatedMavenConfiguration;
                    this.createClassLoaderModelLoaders();
                }
            }
            if (this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                Object object = this.deployableMavenClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
                return object;
            }
            if (this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                Object object = this.pluginMavenClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
                return object;
            }
            if (this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType)) {
                Object object = this.libFolderClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
                return object;
            }
            throw new IllegalStateException(String.format("Artifact type %s not supported", new Object[]{artifactType}));
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        return this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType);
    }
}

