/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.config.spring.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.DslBaseType;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ComplexTypeHolder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ObjectFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

final class ObjectTypeSchemaDelegate {
    private final Map<String, ComplexTypeHolder> registeredComplexTypesHolders = new LinkedHashMap<String, ComplexTypeHolder>();
    private final Map<String, TopLevelElement> registeredGlobalElementTypes = new LinkedHashMap<String, TopLevelElement>();
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final SchemaBuilder builder;
    private final DslSyntaxResolver dsl;

    ObjectTypeSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
        this.dsl = builder.getDslResolver();
    }

    void generatePojoElement(ObjectType type, DslElementSyntax paramSyntax, ParameterDslConfiguration paramDsl, String description, List<TopLevelElement> all, boolean required) {
        if (paramSyntax.supportsChildDeclaration()) {
            if (this.builder.isImported(type)) {
                this.addImportedTypeElement(paramSyntax, description, type, all, required);
            } else if (TypeUtils.getSubstitutionGroup(type).isPresent()) {
                this.declareRefToType(type, paramSyntax, description, all, required);
                this.registerAbstractElement(type, paramSyntax);
            } else if (paramSyntax.isWrapped()) {
                this.declareRefToType(type, paramSyntax, description, all, required);
            } else {
                this.declareTypeInline(type, paramSyntax, description, all, required);
            }
        }
        Optional<DslElementSyntax> typeDsl = this.builder.getDslResolver().resolve(type);
        if (paramDsl.allowsReferences() && typeDsl.isPresent() && typeDsl.get().supportsTopLevelDeclaration() && !this.builder.isImported(type)) {
            this.registerPojoType(type, description);
        }
    }

    private void declareTypeInline(ObjectType objectType, DslElementSyntax paramDsl, String description, List<TopLevelElement> all, boolean required) {
        this.registerPojoComplexType(objectType, null, description);
        String typeName = this.getBaseTypeName(objectType);
        QName localQName = new QName(paramDsl.getNamespace(), typeName, paramDsl.getPrefix());
        this.addChildElementTypeExtension(localQName, description, paramDsl.getElementName(), !paramDsl.supportsAttributeDeclaration() && required, all);
    }

    private void declareRefToType(ObjectType objectType, DslElementSyntax paramDsl, String description, List<TopLevelElement> all, boolean required) {
        this.registerPojoSubtypes(objectType, this.builder.getTypesMapping().getSubTypes(objectType));
        this.addAbstractTypeRef(paramDsl, description, objectType, all, required);
    }

    private void addChildElementTypeExtension(QName base, String description, String name, boolean required, List<TopLevelElement> all) {
        TopLevelElement objectElement = this.builder.createTopLevelElement(name, required ? BigInteger.ONE : BigInteger.ZERO, "1");
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createTypeExtension(base));
        all.add(objectElement);
    }

    private void addImportedTypeElement(DslElementSyntax paramDsl, String description, MetadataType metadataType, List<TopLevelElement> all, boolean required) {
        DslElementSyntax typeDsl = this.builder.getDslResolver().resolve(metadataType).orElseThrow(() -> new IllegalArgumentException(String.format("The given type [%s] is not eligible for Import", this.getId(metadataType))));
        if (paramDsl.isWrapped()) {
            TopLevelElement objectElement = this.builder.createTopLevelElement(paramDsl.getElementName(), BigInteger.ZERO, "1");
            objectElement.setComplexType(new LocalComplexType());
            objectElement.setAnnotation(this.builder.createDocAnnotation(description));
            if (typeDsl.isWrapped()) {
                objectElement.getComplexType().setChoice(this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, metadataType, BigInteger.ZERO, "unbounded"));
            } else {
                ExplicitGroup sequence = new ExplicitGroup();
                sequence.setMinOccurs(BigInteger.ONE);
                sequence.setMaxOccurs("1");
                QName refQName = new QName(paramDsl.getNamespace(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), paramDsl.getPrefix());
                sequence.getParticle().add(this.objectFactory.createElement(this.builder.createRefElement(refQName, false)));
                objectElement.getComplexType().setSequence(sequence);
            }
            all.add(objectElement);
        } else {
            QName extensionBase = new QName(typeDsl.getNamespace(), NameUtils.sanitizeName(this.getId(metadataType)), typeDsl.getPrefix());
            this.addChildElementTypeExtension(extensionBase, description, paramDsl.getElementName(), !paramDsl.supportsAttributeDeclaration() && required, all);
        }
    }

    private void addAbstractTypeRef(DslElementSyntax paramDsl, String description, MetadataType metadataType, List<TopLevelElement> all, boolean required) {
        TopLevelElement objectElement = this.builder.createTopLevelElement(paramDsl.getElementName(), !paramDsl.supportsAttributeDeclaration() && required ? BigInteger.ONE : BigInteger.ZERO, "1");
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createComplexTypeWithAbstractElementRef(metadataType));
        all.add(objectElement);
    }

    private LocalComplexType createComplexTypeWithAbstractElementRef(MetadataType type) {
        DslElementSyntax typeDsl = this.builder.getDslResolver().resolve(type).orElseThrow(() -> new IllegalArgumentException(String.format("No element ref can be created for the given type [%s]", this.getId(type))));
        LocalComplexType complexType = new LocalComplexType();
        if (typeDsl.isWrapped()) {
            complexType.setChoice(this.builder.createTypeRefChoiceLocalOrGlobal(typeDsl, type, BigInteger.ONE, "1"));
        } else {
            ExplicitGroup sequence = new ExplicitGroup();
            sequence.setMinOccurs(BigInteger.ONE);
            sequence.setMaxOccurs("1");
            sequence.getParticle().add(this.objectFactory.createElement(this.createRefToLocalElement(typeDsl, type)));
            complexType.setSequence(sequence);
        }
        return complexType;
    }

    private TopLevelElement createRefToLocalElement(DslElementSyntax typeDsl, MetadataType metadataType) {
        this.registerPojoType(metadataType, "");
        QName qName = new QName(typeDsl.getNamespace(), ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), typeDsl.getPrefix());
        return this.builder.createRefElement(qName, false);
    }

    String registerPojoType(MetadataType metadataType, String description) {
        return this.registerPojoType(metadataType, null, description);
    }

    private String registerPojoType(MetadataType type, MetadataType baseType, String description) {
        if (!this.builder.isImported(type)) {
            this.registerPojoComplexType((ObjectType)type, (ObjectType)baseType, description);
            Optional<DslElementSyntax> typeDsl = this.builder.getDslResolver().resolve(type);
            if (typeDsl.isPresent() && this.shouldRegisterTypeAsElement(type, typeDsl.get())) {
                this.registerPojoGlobalElements(typeDsl.get(), (ObjectType)type, (ObjectType)baseType, description);
            }
        }
        return this.getBaseTypeName(type);
    }

    private boolean shouldRegisterTypeAsElement(MetadataType type, DslElementSyntax typeDsl) {
        return typeDsl.supportsTopLevelDeclaration() || typeDsl.isWrapped() || type instanceof ObjectType && !this.builder.getTypesMapping().getSuperTypes((ObjectType)type).isEmpty();
    }

    private ComplexType registerPojoComplexType(ObjectType type, ObjectType baseType, String description) {
        String typeId = this.getId(type);
        if (this.registeredComplexTypesHolders.get(typeId) != null) {
            return this.registeredComplexTypesHolders.get(typeId).getComplexType();
        }
        QName base = this.getComplexTypeBase(type, baseType);
        Collection fields = baseType == null ? type.getFields() : (Collection)type.getFields().stream().filter(field -> !baseType.getFields().stream().anyMatch(other -> other.getKey().getName().getLocalPart().equals(field.getKey().getName().getLocalPart()))).collect(Collectors.toList());
        ComplexType complexType = this.declarePojoAsType(type, base, description, fields);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(complexType);
        return complexType;
    }

    private QName getComplexTypeBase(ObjectType type, ObjectType baseType) {
        Optional<DslElementSyntax> baseDsl = this.builder.getDslResolver().resolve(baseType);
        if (baseDsl.isPresent()) {
            return new QName(baseDsl.get().getNamespace(), this.getBaseTypeName(baseType), baseDsl.get().getPrefix());
        }
        Optional<DslBaseType> base = TypeUtils.getBaseType(type);
        if (base.isPresent()) {
            return new QName(this.builder.getNamespaceUri(base.get().getPrefix()), base.get().getType(), base.get().getPrefix());
        }
        return SchemaConstants.MULE_ABSTRACT_EXTENSION_TYPE;
    }

    private ComplexType declarePojoAsType(ObjectType metadataType, QName base, String description, Collection<ObjectFieldType> fields) {
        TopLevelComplexType complexType = new TopLevelComplexType();
        this.registeredComplexTypesHolders.put(this.getId(metadataType), new ComplexTypeHolder(complexType, metadataType));
        complexType.setName(NameUtils.sanitizeName(this.getId(metadataType)));
        complexType.setAnnotation(this.builder.createDocAnnotation(description));
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType extension = new ExtensionType();
        extension.setBase(base);
        complexContent.setExtension(extension);
        DslElementSyntax typeDsl = this.dsl.resolve(metadataType).get();
        LinkedList childElements = new LinkedList();
        fields.forEach(field -> {
            String fieldName = field.getKey().getName().getLocalPart();
            DslElementSyntax fieldDsl = typeDsl.getContainedElement(fieldName).orElse(null);
            if (ExtensionMetadataTypeUtils.isFlattenedParameterGroup(field)) {
                this.declareGroupedFields(extension, childElements, (ObjectFieldType)field);
            } else {
                this.declareObjectField(fieldDsl, (ObjectFieldType)field, extension, childElements);
            }
        });
        if (!childElements.isEmpty()) {
            ExplicitGroup all = new ExplicitGroup();
            all.setMaxOccurs("1");
            boolean requiredChilds = childElements.stream().anyMatch(this.builder::isRequired);
            all.setMinOccurs(requiredChilds ? BigInteger.ONE : BigInteger.ZERO);
            childElements.forEach(p -> all.getParticle().add(this.objectFactory.createElement((TopLevelElement)p)));
            extension.setSequence(all);
        }
        return complexType;
    }

    private void declareGroupedFields(ExtensionType extension, List<TopLevelElement> childElements, ObjectFieldType field) {
        DslElementSyntax groupDsl = this.dsl.resolve(field.getValue()).get();
        ((ObjectType)field.getValue()).getFields().forEach(subField -> {
            DslElementSyntax subFieldDsl = groupDsl.getContainedElement(subField.getKey().getName().getLocalPart()).orElse(null);
            this.declareObjectField(subFieldDsl, (ObjectFieldType)subField, extension, childElements);
        });
    }

    private void declareObjectField(DslElementSyntax fieldDsl, ObjectFieldType field, ExtensionType extension, List<TopLevelElement> all) {
        String id;
        ImmutableParameterModel parameter = this.asParameter(field);
        if (fieldDsl == null) {
            fieldDsl = this.dsl.resolve(parameter);
        }
        if ((id = this.getId(field.getValue())).equals(TlsContextFactory.class.getName())) {
            this.builder.addTlsSupport(extension, all);
            return;
        }
        this.builder.declareAsParameter(field.getValue(), extension, parameter, fieldDsl, all);
    }

    private void registerPojoGlobalElements(DslElementSyntax typeDsl, ObjectType type, ObjectType baseType, String description) {
        if (this.registeredGlobalElementTypes.containsKey(this.globalTypeKey(typeDsl))) {
            return;
        }
        QName typeQName = this.getTypeQName(typeDsl, type);
        TopLevelElement abstractElement = this.registerAbstractElement(type, typeQName, typeDsl, baseType);
        if (typeDsl.supportsTopLevelDeclaration() || typeDsl.supportsChildDeclaration() && typeDsl.isWrapped() || !this.builder.getTypesMapping().getSuperTypes(type).isEmpty()) {
            this.registerConcreteGlobalElement(typeDsl, description, abstractElement.getName(), typeQName);
        }
    }

    QName getTypeQName(DslElementSyntax typeDsl, MetadataType type) {
        return new QName(this.builder.getSchema().getTargetNamespace(), this.getBaseTypeName(type), typeDsl.getPrefix());
    }

    TopLevelElement registerAbstractElement(MetadataType type, DslElementSyntax typeDsl) {
        QName typeQName = this.getTypeQName(typeDsl, type);
        TopLevelElement abstractElement = this.registerAbstractElement(type, typeQName, typeDsl, null);
        return abstractElement;
    }

    private TopLevelElement registerAbstractElement(MetadataType type, QName typeQName, DslElementSyntax typeDsl, ObjectType baseType) {
        TopLevelElement element = this.registeredGlobalElementTypes.get(typeDsl.getPrefix() + ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl));
        if (element != null) {
            return element;
        }
        Optional<DslElementSyntax> baseDsl = this.builder.getDslResolver().resolve(baseType);
        if (typeDsl.isWrapped()) {
            this.createGlobalMuleExtensionAbstractElement(typeQName, typeDsl, baseDsl);
        }
        TopLevelElement abstractElement = new TopLevelElement();
        abstractElement.setName(ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl));
        abstractElement.setAbstract(true);
        if (!typeDsl.supportsTopLevelDeclaration()) {
            abstractElement.setType(typeQName);
        }
        if (baseDsl.isPresent() || typeDsl.supportsTopLevelDeclaration()) {
            QName substitutionGroup2 = this.getAbstractElementSubstitutionGroup(typeDsl, baseDsl);
            abstractElement.setSubstitutionGroup(substitutionGroup2);
        }
        TypeUtils.getSubstitutionGroup(type).ifPresent(substitutionGroup -> abstractElement.setSubstitutionGroup(this.builder.resolveSubstitutionGroup((SubstitutionGroup)substitutionGroup)));
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(abstractElement);
        this.registeredGlobalElementTypes.put(typeDsl.getPrefix() + ObjectTypeSchemaDelegate.getAbstractElementName(typeDsl), abstractElement);
        return abstractElement;
    }

    private QName getAbstractElementSubstitutionGroup(DslElementSyntax typeDsl, Optional<DslElementSyntax> baseDsl) {
        QName substitutionGroup;
        if (baseDsl.isPresent()) {
            DslElementSyntax base = baseDsl.get();
            String abstractElementName = typeDsl.supportsTopLevelDeclaration() ? ObjectTypeSchemaDelegate.getGlobalAbstractName(base) : ObjectTypeSchemaDelegate.getAbstractElementName(base);
            substitutionGroup = new QName(base.getNamespace(), abstractElementName, base.getPrefix());
        } else {
            substitutionGroup = typeDsl.isWrapped() ? new QName(typeDsl.getNamespace(), ObjectTypeSchemaDelegate.getGlobalAbstractName(typeDsl), typeDsl.getPrefix()) : SchemaConstants.MULE_ABSTRACT_SHARED_EXTENSION;
        }
        return substitutionGroup;
    }

    private void createGlobalMuleExtensionAbstractElement(QName typeQName, DslElementSyntax typeDsl, Optional<DslElementSyntax> baseDsl) {
        QName globalSubGroup;
        if (baseDsl.isPresent()) {
            DslElementSyntax base = baseDsl.get();
            globalSubGroup = new QName(base.getNamespace(), ObjectTypeSchemaDelegate.getGlobalAbstractName(base), base.getPrefix());
        } else {
            globalSubGroup = SchemaConstants.MULE_ABSTRACT_SHARED_EXTENSION;
        }
        TopLevelElement abstractElement = new TopLevelElement();
        abstractElement.setName(ObjectTypeSchemaDelegate.getGlobalAbstractName(typeDsl));
        abstractElement.setSubstitutionGroup(globalSubGroup);
        abstractElement.setAbstract(true);
        if (!typeDsl.supportsTopLevelDeclaration()) {
            abstractElement.setType(typeQName);
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(abstractElement);
    }

    void registerConcreteGlobalElement(DslElementSyntax typeDsl, String description, String abstractElementName, QName typeQName) {
        if (this.registeredGlobalElementTypes.containsKey(this.globalTypeKey(typeDsl))) {
            return;
        }
        TopLevelElement objectElement = new TopLevelElement();
        objectElement.setName(typeDsl.getElementName());
        objectElement.setSubstitutionGroup(new QName(typeDsl.getNamespace(), abstractElementName, typeDsl.getPrefix()));
        objectElement.setAnnotation(this.builder.createDocAnnotation(description));
        objectElement.setComplexType(this.createTypeExtension(typeQName));
        if (typeDsl.supportsTopLevelDeclaration()) {
            objectElement.getComplexType().getComplexContent().getExtension().getAttributeOrAttributeGroup().add(this.builder.createNameAttribute(false));
        }
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(objectElement);
        this.registeredGlobalElementTypes.put(this.globalTypeKey(typeDsl), objectElement);
    }

    private String globalTypeKey(DslElementSyntax typeDsl) {
        return typeDsl.getPrefix() + typeDsl.getElementName();
    }

    private ImmutableParameterModel asParameter(ObjectFieldType field) {
        return new ImmutableParameterModel(field.getKey().getName().getLocalPart(), "", field.getValue(), false, field.isRequired(), false, TypeUtils.getExpressionSupport(field), MetadataTypeUtils.getDefaultValue(field).orElse(null), TypeUtils.getParameterRole(field), ParameterDslConfiguration.getDefaultInstance(), null, TypeUtils.getLayoutModel(field).orElse(null), null, Collections.emptyList(), Collections.emptySet());
    }

    void registerPojoSubtypes(SubTypesModel subTypesModel) {
        this.registerPojoSubtypes(subTypesModel.getBaseType(), subTypesModel.getSubTypes());
    }

    void registerPojoSubtypes(MetadataType baseType, Collection<ObjectType> subTypes) {
        if (!this.builder.isImported(baseType)) {
            this.registerPojoType(baseType, "");
        }
        subTypes.forEach(subtype -> this.registerPojoType((MetadataType)subtype, baseType, ""));
    }

    private String getId(MetadataType type) {
        return ExtensionMetadataTypeUtils.getId(type).orElseThrow(() -> new IllegalArgumentException("Cannot register a type without id"));
    }

    LocalComplexType createTypeExtension(QName base) {
        LocalComplexType complexType = new LocalComplexType();
        ComplexContent complexContent = new ComplexContent();
        complexType.setComplexContent(complexContent);
        ExtensionType extension = new ExtensionType();
        extension.setBase(base);
        complexContent.setExtension(extension);
        return complexType;
    }

    private String getBaseTypeName(MetadataType type) {
        return NameUtils.sanitizeName(this.getId(type));
    }

    static String getGlobalAbstractName(DslElementSyntax dsl) {
        return "global-" + ObjectTypeSchemaDelegate.getAbstractElementName(dsl);
    }

    static String getAbstractElementName(DslElementSyntax dsl) {
        return "abstract-" + dsl.getElementName();
    }
}

