/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.config;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.time.TimeSupplier;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.DynamicConfigPolicy;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticConnectionProviderResolver;

class ConfigurationProviderObjectFactory
extends AbstractExtensionObjectFactory<ConfigurationProvider>
implements ObjectFactory<ConfigurationProvider> {
    private final String name;
    private final ExtensionModel extensionModel;
    private final ConfigurationModel configurationModel;
    private final ConfigurationProviderFactory configurationProviderFactory = new DefaultConfigurationProviderFactory();
    private DynamicConfigPolicy dynamicConfigPolicy;
    private Optional<ConnectionProviderValueResolver> connectionProviderResolver = Optional.empty();
    private ConfigurationProvider instance;
    private boolean requiresConnection = false;
    @Inject
    private MuleContext muleContext;
    @Inject
    private TimeSupplier timeSupplier;

    ConfigurationProviderObjectFactory(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        super(muleContext);
        this.name = name;
        this.extensionModel = extensionModel;
        this.configurationModel = configurationModel;
    }

    @Override
    public ConfigurationProvider doGetObject() throws Exception {
        if (this.instance == null) {
            this.instance = this.createInnerInstance();
        }
        return this.instance;
    }

    private ConfigurationProvider createInnerInstance() throws ConfigurationException {
        ConfigurationProvider configurationProvider;
        ResolverSet resolverSet = this.parametersResolver.getParametersAsHashedResolverSet(this.configurationModel, this.muleContext);
        ConnectionProviderValueResolver connectionProviderResolver = this.getConnectionProviderResolver();
        connectionProviderResolver.getResolverSet().ifPresent(resolver -> LifecycleUtils.initialiseIfNeeded(resolver, true, this.muleContext));
        try {
            configurationProvider = resolverSet.isDynamic() || connectionProviderResolver.isDynamic() ? this.configurationProviderFactory.createDynamicConfigurationProvider(this.name, this.extensionModel, this.configurationModel, resolverSet, connectionProviderResolver, this.getDynamicConfigPolicy(), this.muleContext) : this.configurationProviderFactory.createStaticConfigurationProvider(this.name, this.extensionModel, this.configurationModel, resolverSet, connectionProviderResolver, this.muleContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return configurationProvider;
    }

    private DynamicConfigPolicy getDynamicConfigPolicy() {
        if (this.dynamicConfigPolicy == null) {
            this.dynamicConfigPolicy = DynamicConfigPolicy.getDefault(this.timeSupplier);
        }
        return this.dynamicConfigPolicy;
    }

    private ConnectionProviderValueResolver getConnectionProviderResolver() {
        return this.connectionProviderResolver.orElseGet(() -> {
            if (this.requiresConnection) {
                return new ImplicitConnectionProviderValueResolver(this.name, this.extensionModel, this.configurationModel, this.muleContext);
            }
            return new StaticConnectionProviderResolver(null, null);
        });
    }

    public void setDynamicConfigPolicy(DynamicConfigPolicy dynamicConfigPolicy) {
        this.dynamicConfigPolicy = dynamicConfigPolicy;
    }

    public void setConnectionProviderResolver(ConnectionProviderResolver connectionProviderResolver) {
        this.connectionProviderResolver = Optional.ofNullable(connectionProviderResolver);
    }

    public void setRequiresConnection(boolean requiresConnection) {
        this.requiresConnection = requiresConnection;
    }
}

