/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Set;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.enricher.ModuleErrors;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;

public class ExtensionsErrorsDeclarationEnricher
implements DeclarationEnricher {
    private static final String MULE = Errors.CORE_NAMESPACE_NAME;

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private class EnricherDelegate
    implements DeclarationEnricher {
        private ErrorsModelFactory muleErrorsModelFactory;

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            final ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            this.muleErrorsModelFactory = new ErrorsModelFactory((ErrorTypeDefinition[])MuleErrors.class.getEnumConstants(), MULE);
            final Set<ErrorModel> errorModels = extensionDeclaration.getErrorModels();
            new IdempotentDeclarationWalker(){

                @Override
                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration operationDeclaration) {
                    if (operationDeclaration.getModelProperty(ConnectivityModelProperty.class).isPresent()) {
                        operationDeclaration.addErrorModel(EnricherDelegate.this.getErrorModel(ModuleErrors.CONNECTIVITY, errorModels, operationDeclaration));
                        operationDeclaration.addErrorModel(EnricherDelegate.this.getErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModels, operationDeclaration));
                    }
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration sourceDeclaration) {
                    sourceDeclaration.getSuccessCallback().ifPresent(callback -> {
                        EnricherDelegate.this.registerError(MuleErrors.SOURCE_RESPONSE_SEND, sourceDeclaration, extensionDeclaration);
                        EnricherDelegate.this.registerError(MuleErrors.SOURCE_RESPONSE_GENERATE, sourceDeclaration, extensionDeclaration);
                    });
                    sourceDeclaration.getErrorCallback().ifPresent(callback -> {
                        EnricherDelegate.this.registerError(MuleErrors.SOURCE_ERROR_RESPONSE_SEND, sourceDeclaration, extensionDeclaration);
                        EnricherDelegate.this.registerError(MuleErrors.SOURCE_ERROR_RESPONSE_GENERATE, sourceDeclaration, extensionDeclaration);
                    });
                }
            }.walk(extensionDeclaration);
        }

        private void registerError(MuleErrors error, SourceDeclaration sourceDeclaration, ExtensionDeclaration extensionDeclaration) {
            ErrorModel errorModel = this.muleErrorsModelFactory.getErrorModel(error);
            extensionDeclaration.addErrorModel(errorModel);
            sourceDeclaration.addErrorModel(errorModel);
        }

        private ErrorModel getErrorModel(ErrorTypeDefinition<?> errorTypeDefinition, Set<ErrorModel> errorModels, ComponentDeclaration component) {
            return errorModels.stream().filter(error -> !error.getNamespace().equals(MULE) && error.getType().equals(errorTypeDefinition.getType())).findFirst().orElseThrow(() -> new IllegalModelDefinitionException(String.format("Trying to add the '%s' Error to the Component '%s' but the Extension doesn't declare it", errorTypeDefinition, component.getName())));
        }
    }
}

