/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.TemplateParser;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.internal.client.ComplexParameter;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class DefaultExtensionsClient
implements ExtensionsClient {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyManager policyManager;
    @Inject
    private ExtensionManager extensionManager;
    private final Map<Pair<String, String>, OperationModel> operations = new LinkedHashMap<Pair<String, String>, OperationModel>();
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();

    @Override
    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extension, String operation, OperationParameters parameters) {
        OperationMessageProcessor processor = this.createProcessor(extension, operation, parameters);
        Mono resultMono = Mono.from(processor.apply((Publisher<InternalEvent>)Mono.just((Object)MuleExtensionUtils.getInitialiserEvent(this.muleContext)))).map(event -> Result.builder(event.getMessage()).build()).onErrorMap(Exceptions::unwrap).doAfterTerminate((r, t) -> this.disposeProcessor(processor));
        return resultMono.toFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        OperationMessageProcessor processor = this.createProcessor(extension, operation, params);
        try {
            InternalEvent process = processor.process(MuleExtensionUtils.getInitialiserEvent(this.muleContext));
            Result result = Result.builder(process.getMessage()).build();
            return result;
        }
        finally {
            this.disposeProcessor(processor);
        }
    }

    private OperationMessageProcessor createProcessor(String extensionName, String operationName, OperationParameters parameters) {
        ExtensionModel extension = this.findExtension(extensionName);
        OperationModel operation = this.findOperation(extension, operationName);
        ConfigurationProvider config = parameters.getConfigName().map(this::findConfiguration).orElse(null);
        Map<String, ValueResolver> resolvedParams = this.resolveParameters(parameters.get(), MuleExtensionUtils.getInitialiserEvent(this.muleContext));
        try {
            OperationMessageProcessor processor = new OperationMessageProcessorBuilder(extension, operation, this.policyManager, this.muleContext).setConfigurationProvider(config).setParameters(resolvedParams).build();
            processor.initialise();
            processor.start();
            return processor;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create Operation Message Processor"), (Throwable)e);
        }
    }

    private Map<String, ValueResolver> resolveParameters(Map<String, Object> parameters, InternalEvent event) {
        LinkedHashMap<String, ValueResolver> values = new LinkedHashMap<String, ValueResolver>();
        parameters.forEach((name, value) -> {
            if (value instanceof ComplexParameter) {
                ComplexParameter complex = (ComplexParameter)value;
                DefaultObjectBuilder builder = new DefaultObjectBuilder(complex.getType());
                this.resolveParameters(complex.getParameters(), event).forEach((propertyName, valueResolver) -> {
                    try {
                        LifecycleUtils.initialiseIfNeeded(valueResolver, true, this.muleContext);
                        builder.addPropertyResolver((String)propertyName, (ValueResolver<Object>)valueResolver);
                    }
                    catch (InitialisationException e) {
                        throw new MuleRuntimeException(e);
                    }
                });
                try {
                    values.put((String)name, new StaticValueResolver(builder.build(ValueResolvingContext.from(event))));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not construct parameter [%s]", name)), (Throwable)e);
                }
            } else if (value instanceof String && this.parser.isContainsTemplate((String)value)) {
                values.put((String)name, new ExpressionValueResolver((String)value));
            } else {
                values.put((String)name, new StaticValueResolver<Object>(value));
            }
        });
        return values;
    }

    private OperationModel findOperation(ExtensionModel extensionModel, final String operationName) {
        return this.operations.computeIfAbsent(new Pair<String, String>(extensionModel.getName(), operationName), ope -> {
            final Reference operation = new Reference();
            IdempotentExtensionWalker walker = new IdempotentExtensionWalker(){

                @Override
                protected void onOperation(OperationModel operationModel) {
                    if (operationName.equals(operationModel.getName())) {
                        operation.set(operationModel);
                        this.stop();
                    }
                }
            };
            walker.walk(extensionModel);
            if (operation.get() == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No Operation [" + operationName + "] Found"));
            }
            return (OperationModel)operation.get();
        });
    }

    private ConfigurationProvider findConfiguration(String configName) {
        return this.extensionManager.getConfigurationProvider(configName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No configuration [" + configName + "] found")));
    }

    private ExtensionModel findExtension(String extensionName) {
        return this.extensionManager.getExtension(extensionName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("No Extension [" + extensionName + "] Found")));
    }

    private void disposeProcessor(OperationMessageProcessor processor) {
        try {
            processor.stop();
            processor.dispose();
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Error while disposing the executing operation"), (Throwable)e);
        }
    }
}

