/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.function;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.function.FunctionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ReflectiveExpressionFunctionExecutor
implements Lifecycle,
FunctionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectiveExpressionFunctionExecutor.class);
    private final Method method;
    private final FunctionModel model;
    private final DataType returnType;
    private final Object componentInstance;
    private final ClassLoader extensionClassLoader;
    private final List<FunctionParameter> functionParameters;

    public ReflectiveExpressionFunctionExecutor(FunctionModel model, DataType returnType, List<FunctionParameter> functionParameters, Method method, Object componentInstance) {
        this.model = model;
        this.method = method;
        this.returnType = returnType;
        this.componentInstance = componentInstance;
        this.functionParameters = functionParameters;
        this.extensionClassLoader = method.getDeclaringClass().getClassLoader();
    }

    @Override
    public Object call(Object[] parameters, BindingContext context) {
        return ClassUtils.withContextClassLoader(this.extensionClassLoader, () -> ReflectionUtils.invokeMethod((Method)this.method, (Object)this.componentInstance, (Object[])parameters));
    }

    @Override
    public Optional<DataType> returnType() {
        return Optional.ofNullable(this.returnType);
    }

    @Override
    public List<FunctionParameter> parameters() {
        return this.functionParameters;
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.componentInstance);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.componentInstance);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.componentInstance);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.componentInstance, LOGGER);
    }
}

