/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.AbstractExecutionContextAdapterDecorator;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.reactivestreams.Publisher;

class PrecalculatedExecutionContextAdapter
extends AbstractExecutionContextAdapterDecorator<OperationModel> {
    private Optional<ConfigurationInstance> configuration;
    private OperationExecutor operation;

    PrecalculatedExecutionContextAdapter(ExecutionContextAdapter<OperationModel> decorated, OperationExecutor operation) {
        super(decorated);
        this.configuration = decorated.getConfiguration().map(config -> {
            if (config instanceof Interceptable) {
                return new ExecutionContextConfigurationDecorator((ConfigurationInstance)config, ((Interceptable)((Object)config)).getInterceptors().stream().map(interceptor -> new InterceptorDecorator((Interceptor)interceptor)).collect(Collectors.toList()));
            }
            return config;
        });
        this.operation = new OperationExecutorDecorator(operation);
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration() {
        return this.configuration;
    }

    public OperationExecutor getOperationExecutor() {
        return this.operation;
    }

    private static class InterceptorDecorator
    implements Interceptor {
        private AtomicInteger beforeCalled = new AtomicInteger();
        private Interceptor decorated;

        public InterceptorDecorator(Interceptor decorated) {
            this.decorated = decorated;
        }

        @Override
        public void before(ExecutionContext<OperationModel> executionContext) throws Exception {
            if (this.beforeCalled.getAndIncrement() == 0) {
                this.decorated.before(executionContext);
            }
        }

        @Override
        public void onSuccess(ExecutionContext<OperationModel> executionContext, Object result) {
            this.decorated.onSuccess(executionContext, result);
        }

        @Override
        public Throwable onError(ExecutionContext<OperationModel> executionContext, Throwable exception) {
            return this.decorated.onError(executionContext, exception);
        }

        @Override
        public void after(ExecutionContext<OperationModel> executionContext, Object result) {
            if (this.beforeCalled.decrementAndGet() == 0) {
                this.decorated.after(executionContext, result);
            }
        }
    }

    private static class ExecutionContextConfigurationDecorator
    implements Interceptable,
    ConfigurationInstance {
        private ConfigurationInstance decorated;
        private List<Interceptor> interceptors;

        public ExecutionContextConfigurationDecorator(ConfigurationInstance decorated, List<Interceptor> interceptors) {
            this.decorated = decorated;
            this.interceptors = interceptors;
        }

        @Override
        public String getName() {
            return this.decorated.getName();
        }

        @Override
        public ConfigurationModel getModel() {
            return this.decorated.getModel();
        }

        @Override
        public Object getValue() {
            return this.decorated.getValue();
        }

        @Override
        public ConfigurationState getState() {
            return this.decorated.getState();
        }

        @Override
        public ConfigurationStats getStatistics() {
            return this.decorated.getStatistics();
        }

        @Override
        public Optional<ConnectionProvider> getConnectionProvider() {
            return this.decorated.getConnectionProvider();
        }

        @Override
        public List<Interceptor> getInterceptors() {
            return this.interceptors;
        }
    }

    private static class OperationExecutorDecorator
    implements OperationExecutor,
    Interceptable {
        private OperationExecutor decorated;
        private List<Interceptor> operationExecutorInterceptors;

        public OperationExecutorDecorator(OperationExecutor decorated) {
            this.decorated = decorated;
            this.operationExecutorInterceptors = decorated instanceof Interceptable ? ((Interceptable)((Object)decorated)).getInterceptors().stream().map(interceptor -> new InterceptorDecorator((Interceptor)interceptor)).collect(Collectors.toList()) : Collections.emptyList();
        }

        @Override
        public Publisher<Object> execute(ExecutionContext<OperationModel> executionContext) {
            return this.decorated.execute(executionContext);
        }

        @Override
        public List<Interceptor> getInterceptors() {
            return this.operationExecutorInterceptors;
        }
    }
}

