/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Message message;
    private final Processor messageProcessor;
    private final SourceCompletionHandler completionHandler;

    ModuleFlowProcessingTemplate(Message message, Processor messageProcessor, SourceCompletionHandler completionHandler) {
        this.message = message;
        this.messageProcessor = messageProcessor;
        this.completionHandler = completionHandler;
    }

    @Override
    public CheckedFunction<InternalEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return this.completionHandler::createResponseParameters;
    }

    @Override
    public CheckedFunction<InternalEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return this.completionHandler::createFailureResponseParameters;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public InternalEvent routeEvent(InternalEvent muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    @Override
    public Publisher<InternalEvent> routeEventAsync(InternalEvent event) {
        return Mono.just((Object)event).transform((Function)this.messageProcessor);
    }

    @Override
    public Publisher<Void> sendResponseToClient(InternalEvent response, Map<String, Object> parameters) {
        return this.completionHandler.onCompletion(response, parameters);
    }

    @Override
    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters) {
        return this.completionHandler.onFailure(messagingException, parameters);
    }

    @Override
    public void afterPhaseExecution(Either<MessagingException, InternalEvent> either) {
        either.apply(messagingException -> this.completionHandler.onTerminate(Either.left(messagingException)), event -> this.completionHandler.onTerminate(either));
    }
}

