/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.coreextension;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.ArtifactClassLoaderManagerAware;
import org.mule.runtime.container.api.CoreExtensionsAware;
import org.mule.runtime.container.api.MuleCoreExtension;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDependencyResolver;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionDiscoverer;
import org.mule.runtime.module.launcher.coreextension.MuleCoreExtensionManagerServer;
import org.mule.runtime.module.repository.api.RepositoryService;
import org.mule.runtime.module.repository.api.RepositoryServiceAware;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.ToolingServiceAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleCoreExtensionManagerServer
implements MuleCoreExtensionManagerServer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleCoreExtensionManagerServer.class);
    private final MuleCoreExtensionDiscoverer coreExtensionDiscoverer;
    private final MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver;
    private List<MuleCoreExtension> coreExtensions = new LinkedList<MuleCoreExtension>();
    private DeploymentService deploymentService;
    private RepositoryService repositoryService;
    private ToolingService toolingService;
    private List<MuleCoreExtension> orderedCoreExtensions;
    private ArtifactClassLoaderManager artifactClassLoaderManager;

    public DefaultMuleCoreExtensionManagerServer(MuleCoreExtensionDiscoverer coreExtensionDiscoverer, MuleCoreExtensionDependencyResolver coreExtensionDependencyResolver) {
        this.coreExtensionDiscoverer = coreExtensionDiscoverer;
        this.coreExtensionDependencyResolver = coreExtensionDependencyResolver;
    }

    @Override
    public void dispose() {
        for (MuleCoreExtension extension : this.coreExtensions) {
            try {
                extension.dispose();
            }
            catch (Exception ex) {
                logger.error("Error disposing core extension " + extension.getName(), (Throwable)ex);
            }
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.coreExtensions = this.coreExtensionDiscoverer.discover();
            this.orderedCoreExtensions = this.coreExtensionDependencyResolver.resolveDependencies(this.coreExtensions);
            this.initializeCoreExtensions();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void start() throws MuleException {
        logger.info("Starting core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            extension.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.orderedCoreExtensions == null) {
            return;
        }
        for (int i = this.orderedCoreExtensions.size() - 1; i >= 0; --i) {
            MuleCoreExtension extension = this.orderedCoreExtensions.get(i);
            try {
                extension.stop();
                continue;
            }
            catch (Throwable e) {
                logger.warn("Error stopping core extension: " + extension.getName(), e);
            }
        }
    }

    private void initializeCoreExtensions() throws InitialisationException, DefaultMuleException {
        logger.info("Initializing core extensions");
        for (MuleCoreExtension extension : this.orderedCoreExtensions) {
            if (extension instanceof DeploymentServiceAware) {
                ((DeploymentServiceAware)((Object)extension)).setDeploymentService(this.deploymentService);
            }
            if (extension instanceof RepositoryServiceAware) {
                ((RepositoryServiceAware)((Object)extension)).setRepositoryService(this.repositoryService);
            }
            if (extension instanceof ToolingServiceAware) {
                ((ToolingServiceAware)((Object)extension)).setToolingService(this.toolingService);
            }
            if (extension instanceof DeploymentListener) {
                this.deploymentService.addDeploymentListener((DeploymentListener)((Object)extension));
            }
            if (extension instanceof CoreExtensionsAware) {
                ((CoreExtensionsAware)((Object)extension)).setCoreExtensions(this.orderedCoreExtensions);
            }
            if (extension instanceof ArtifactClassLoaderManagerAware) {
                ((ArtifactClassLoaderManagerAware)((Object)extension)).setArtifactClassLoaderManager(this.artifactClassLoaderManager);
            }
            extension.initialise();
        }
    }

    @Override
    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public void setToolingService(ToolingService toolingService) {
        this.toolingService = toolingService;
    }

    @Override
    public void setArtifactClassLoaderManager(ArtifactClassLoaderManager artifactClassLoaderManager) {
        this.artifactClassLoaderManager = artifactClassLoaderManager;
    }
}

