/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfiguratonFileWatcher;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.module.launcher.log4j2.MuleLoggerContext;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

final class LoggerContextConfigurer {
    private static final String MULE_APP_LOG_FILE_TEMPLATE = "mule-app-%s.log";
    private static final String MULE_DOMAIN_LOG_FILE_TEMPLATE = "mule-domain-%s.log";
    private static final String PATTERN_LAYOUT = "%-5p %d [%t] %c: %m%n";
    private static final int DEFAULT_MONITOR_INTERVAL_SECS = 60;
    static final String FORCED_CONSOLE_APPENDER_NAME = "Forced-Console";
    static final String PER_APP_FILE_APPENDER_NAME = "defaultFileAppender";

    LoggerContextConfigurer() {
    }

    protected void configure(MuleLoggerContext context) {
        this.disableShutdownHook(context);
        this.configureMonitor(context);
    }

    protected void update(MuleLoggerContext context) {
        boolean forceConsoleLog;
        boolean bl = forceConsoleLog = System.getProperty("mule.forceConsoleLog") != null;
        if (context.getConfigFile() == null && !forceConsoleLog) {
            this.removeConsoleAppender(context);
        }
        if (context.isArtifactClassloader()) {
            this.addDefaultArtifactContext(context);
        } else if (!context.isStandlone()) {
            this.addDefaultAppender(context, "mule-main.log");
        }
        if (forceConsoleLog && !this.hasAppender(context, ConsoleAppender.class)) {
            this.forceConsoleAppender(context);
        }
    }

    private void disableShutdownHook(LoggerContext context) {
        try {
            ClassUtils.setFieldValue(context.getConfiguration(), "isShutdownHookEnabled", false, true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not configure shutdown hook. Unexpected configuration type"), (Throwable)e);
        }
    }

    private void configureMonitor(MuleLoggerContext context) {
        Configuration configuration = context.getConfiguration();
        File configFile = null;
        if (context.getConfigFile() != null) {
            configFile = new File(context.getConfigFile().getPath());
        } else if (!StringUtils.isEmpty((CharSequence)configuration.getName())) {
            configFile = new File(configuration.getName());
        }
        if (configFile != null && configuration instanceof Reconfigurable) {
            configuration.getWatchManager().setIntervalSeconds(60);
            ConfiguratonFileWatcher watcher = new ConfiguratonFileWatcher((Reconfigurable)configuration, this.getListeners(configuration));
            configuration.getWatchManager().watchFile(configFile, (FileWatcher)watcher);
        }
    }

    private List<ConfigurationListener> getListeners(Configuration configuration) {
        try {
            return (List)ClassUtils.getFieldValue(configuration, "listeners", true);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not get listeners. Unexpected configuration type"), (Throwable)e);
        }
    }

    private void addDefaultAppender(MuleLoggerContext context, String logFilePath) {
        RollingFileAppender appender = this.createRollingFileAppender(logFilePath, ".%d{yyyy-MM-dd}", PER_APP_FILE_APPENDER_NAME, context.getConfiguration());
        this.doAddAppender(context, (Appender)appender);
    }

    private void forceConsoleAppender(MuleLoggerContext context) {
        ConsoleAppender appender = ConsoleAppender.createAppender(this.createLayout(context.getConfiguration()), null, null, (String)FORCED_CONSOLE_APPENDER_NAME, null, null);
        this.doAddAppender(context, (Appender)appender);
    }

    private void doAddAppender(LoggerContext context, Appender appender) {
        appender.start();
        context.getConfiguration().addAppender(appender);
        this.getRootLogger(context).addAppender(appender, Level.ALL, null);
    }

    private RollingFileAppender createRollingFileAppender(String logFilePath, String filePattern, String appenderName, Configuration configuration) {
        TimeBasedTriggeringPolicy triggeringPolicy = TimeBasedTriggeringPolicy.createPolicy((String)"1", (String)"true");
        DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.createStrategy((String)"30", (String)"1", null, (String)String.valueOf(0), null, (boolean)true, (Configuration)configuration);
        return RollingFileAppender.createAppender((String)logFilePath, (String)(logFilePath + filePattern), (String)"true", (String)appenderName, (String)"true", null, null, (TriggeringPolicy)triggeringPolicy, (RolloverStrategy)rolloverStrategy, this.createLayout(configuration), null, null, null, null, (Configuration)configuration);
    }

    private Layout<? extends Serializable> createLayout(Configuration configuration) {
        return PatternLayout.createLayout((String)PATTERN_LAYOUT, null, (Configuration)configuration, null, null, (boolean)true, (boolean)false, null, null);
    }

    private void addDefaultArtifactContext(MuleLoggerContext context) {
        if (context.isStopping()) {
            return;
        }
        String logFileNameTemplate = this.getFilenamePattern(context);
        if (logFileNameTemplate == null) {
            return;
        }
        String artifactName = context.getArtifactName();
        String logName = String.format(logFileNameTemplate, artifactName != null ? artifactName : "");
        File logDir = new File(MuleContainerBootstrapUtils.getMuleBase(), "logs");
        File logFile = new File(logDir, logName);
        if (context.getConfigLocation() == null) {
            this.addDefaultAppender(context, logFile.getAbsolutePath());
        } else if (!this.hasFileAppender(context) && this.isUrlInsideDirectory(context.getConfigFile(), MuleContainerBootstrapUtils.getMuleConfDir()) || context.getConfiguration().getAppenders().isEmpty()) {
            this.addDefaultAppender(context, logFile.getAbsolutePath());
            this.removeConsoleAppender(context);
        }
    }

    private void removeConsoleAppender(LoggerContext context) {
        for (Appender appender : this.getRootLogger(context).getAppenders().values()) {
            if (!(appender instanceof ConsoleAppender)) continue;
            this.removeAppender(context, appender);
            this.getRootLogger(context).removeAppender(appender.getName());
        }
    }

    private boolean hasFileAppender(LoggerContext context) {
        return this.hasAppender(context, FileAppender.class, RollingFileAppender.class, RandomAccessFileAppender.class);
    }

    private boolean hasAppender(LoggerContext context, Class<? extends Appender> ... appenderTypes) {
        for (Appender appender : this.getRootLogger(context).getAppenders().values()) {
            for (Class<? extends Appender> appenderType : appenderTypes) {
                if (!appenderType.isInstance(appender)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUrlInsideDirectory(URI uri, File directory) {
        URL url;
        if (uri == null) {
            return false;
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not locate file " + uri), (Throwable)e);
        }
        if (directory != null && FileUtils.isFile(url)) {
            File uriFile = new File(uri);
            return directory.equals(uriFile.getParentFile());
        }
        return false;
    }

    private String getFilenamePattern(MuleLoggerContext context) {
        if (context.isArtifactClassloader()) {
            return context.isApplicationClassloader() ? MULE_APP_LOG_FILE_TEMPLATE : MULE_DOMAIN_LOG_FILE_TEMPLATE;
        }
        return null;
    }

    private LoggerConfig getRootLogger(LoggerContext context) {
        return context.getConfiguration().getRootLogger();
    }

    private void removeAppender(LoggerContext context, Appender appender) {
        ((AbstractConfiguration)context.getConfiguration()).removeAppender(appender.getName());
    }
}

